/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.LegacyMessageParser;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageClickEvent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageHoverEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBuilder<MESSAGE_BUILDER extends MessageBuilder, MESSAGE extends Message> {
    private final List<MessageComponent> messageList = new ArrayList<MessageComponent>();
    private static final MessageComponent NEW_LINE_HELPER = MessageComponent.makeNewLineComponent();
    private static Constructor MESSAGE_CONSTRUCTOR = null;
    private MessageComponent current;

    public MessageBuilder() {
        this(new MessageComponent());
    }

    public MessageBuilder(MessageComponent initComponent) {
        this.current = initComponent;
        if (initComponent != null) {
            this.messageList.add(initComponent);
        }
    }

    public MessageBuilder(Collection<? extends MessageComponent> initCollection) {
        this.append(initCollection);
    }

    public MessageBuilder(String text) {
        this(new MessageComponent(text, new MessageFormat[0]));
    }

    public MessageBuilder(String text, MessageColor color, MessageFormat ... formats) {
        this(new MessageComponent(text, color, formats));
    }

    public MESSAGE_BUILDER appendNewLine() {
        return this.append(NEW_LINE_HELPER);
    }

    public MESSAGE_BUILDER append() {
        try {
            return this.append(new MessageComponent());
        }
        catch (Exception e) {
            e.printStackTrace();
            return (MESSAGE_BUILDER)this;
        }
    }

    public MESSAGE_BUILDER append(String text, MessageFormat ... formats) {
        try {
            return this.append(new MessageComponent(text, formats));
        }
        catch (Exception e) {
            e.printStackTrace();
            return (MESSAGE_BUILDER)this;
        }
    }

    public MESSAGE_BUILDER append(String text, MessageColor color, MessageFormat ... formats) {
        try {
            return this.append(new MessageComponent(text, color, formats));
        }
        catch (Exception e) {
            e.printStackTrace();
            return (MESSAGE_BUILDER)this;
        }
    }

    public MESSAGE_BUILDER append(MessageComponent ... components) {
        if (components != null && components.length > 0) {
            if (this.messageList.size() > 1 && this.current.isEmpty()) {
                this.messageList.remove(this.messageList.size() - 1);
            }
            this.current = components[components.length - 1];
            Collections.addAll(this.messageList, components);
        }
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER append(Collection<? extends MessageComponent> components) {
        this.messageList.addAll(components);
        this.current = this.messageList.get(this.messageList.size() - 1);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER appendJson(String json) {
        try {
            return this.append(MessageComponent.fromJson(json));
        }
        catch (Exception ignored) {
            return this.append(json, new MessageFormat[0]);
        }
    }

    public MESSAGE_BUILDER appendLegacy(String legacyMessage) {
        new LegacyMessageParser(this).parse(legacyMessage);
        return (MESSAGE_BUILDER)this;
    }

    protected MessageComponent getCurrentComponent() {
        return this.current;
    }

    public int size() {
        return this.messageList.size();
    }

    public Iterator<MessageComponent> iterator() {
        return this.messageList.iterator();
    }

    public MESSAGE_BUILDER text(String text) {
        this.getCurrentComponent().setText(text);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER color(String color) {
        this.getCurrentComponent().setColor(color);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER color(MessageColor color) {
        this.getCurrentComponent().setColor(color);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER format(MessageFormat ... formats) throws IllegalArgumentException {
        this.getCurrentComponent().setFormats(formats);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER font(@Nullable String font) {
        this.getCurrentComponent().setFont(font);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER bold() {
        this.getCurrentComponent().setBold();
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER italic() {
        this.getCurrentComponent().setItalic();
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER underlined() {
        this.getCurrentComponent().setUnderlined();
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER obfuscated() {
        this.getCurrentComponent().setObfuscated();
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER strikethrough() {
        this.getCurrentComponent().setStrikethrough();
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER onClick(MessageClickEvent.ClickEventAction action, String value) {
        this.getCurrentComponent().onClick(action, value);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER file(String path) {
        this.getCurrentComponent().file(path);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER link(String url) {
        this.getCurrentComponent().link(url);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER suggest(String command) {
        this.getCurrentComponent().suggest(command);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER command(String command) {
        this.getCurrentComponent().command(command);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER insert(String insert) {
        this.getCurrentComponent().setInsertion(insert);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER onHover(MessageHoverEvent.HoverEventAction action, String value) {
        this.getCurrentComponent().onHover(action, value);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER onHover(MessageHoverEvent.HoverEventAction action, Collection<? extends MessageComponent> value) {
        this.getCurrentComponent().onHover(action, value);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER achievementTooltip(String name) {
        this.getCurrentComponent().achievementTooltip(name);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER statisticTooltip(String name) {
        this.getCurrentComponent().statisticTooltip(name);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER itemTooltip(String itemJSON) {
        this.getCurrentComponent().itemTooltip(itemJSON);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER tooltip(String ... lines) {
        this.getCurrentComponent().tooltip(lines);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER formattedTooltip(MessageComponent ... text) throws IllegalArgumentException {
        this.getCurrentComponent().formattedTooltip(text);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER formattedTooltip(MESSAGE ... lines) throws IllegalArgumentException {
        this.getCurrentComponent().formattedTooltip((Message[])lines);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE_BUILDER extra(MessageComponent ... extras) {
        this.getCurrentComponent().extra(extras);
        return (MESSAGE_BUILDER)this;
    }

    public MESSAGE getMessage() {
        try {
            return (MESSAGE)((Message)MESSAGE_CONSTRUCTOR.newInstance(this.getJsonMessageAsList()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<MessageComponent> getJsonMessageAsList() {
        return new ArrayList<MessageComponent>(this.messageList);
    }

    public MessageComponent[] getJsonMessage() {
        MessageComponent[] array = (MessageComponent[])Array.newInstance(MessageComponent.class, this.messageList.size());
        return this.messageList.toArray(array);
    }

    @NotNull
    public MessageComponent getAsComponent() {
        if (this.messageList.size() == 1) {
            return this.messageList.get(0);
        }
        if (this.messageList.size() == 2 && this.messageList.get(0).isEmpty()) {
            return this.messageList.get(1);
        }
        MessageComponent component = new MessageComponent("", new MessageFormat[0]);
        if (this.messageList.size() > 1) {
            component.extra = this.getJsonMessageAsList();
            component.extra.removeIf(messageComponent -> messageComponent == null || messageComponent.isEmpty());
        }
        return component;
    }

    public String getClassicMessage() {
        return MessageComponent.getClassicMessage(this.messageList);
    }

    @NotNull
    public String getJson() {
        return MessageComponent.toJSON(this.getJsonMessage());
    }

    public void clear() {
        this.messageList.clear();
        this.append();
    }
}

