/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.IPlaceholderable;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Placeholder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.PlaceholderHandler;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.Message.IMessage;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Message<MESSAGE extends Message<?, ?, ?>, PLAYER, COMMAND_SENDER>
implements IMessage<PLAYER, COMMAND_SENDER>,
IPlaceholderable {
    private static Constructor<? extends MessageBuilder> MESSAGE_BUILDER_CONSTRUCTOR;
    protected IMetadata optionalParameters = null;
    protected String json;
    protected String fallback;
    protected List<MessageComponent> messageComponents = null;
    protected boolean placeholderApiEnabled = false;
    private boolean legacy = false;
    private boolean useStringFormat;
    private PlaceholderHandler placeholderHandler = null;

    protected static void setMessageComponentClass(Constructor<? extends MessageBuilder> messageBuilderConstructor) {
        MESSAGE_BUILDER_CONSTRUCTOR = messageBuilderConstructor;
    }

    protected Message(@NotNull String message) {
        String errorMessage = null;
        try {
            this.messageComponents = MessageComponent.fromJson(message);
        }
        catch (Exception e) {
            errorMessage = StringUtils.getErrorMessage(e);
        }
        if (this.messageComponents != null) {
            this.json = message;
            this.fallback = this.getClassicMessage();
        } else {
            this.fallback = message;
            if (message.isEmpty()) {
                this.messageComponents = new ArrayList<MessageComponent>();
                this.json = "[\"\",{\"text\":\"\"}]";
                return;
            }
            if (message.length() > 8 && message.charAt(0) != '&' && message.charAt(0) != '\u00a7' && StringUtils.containsAny(message, "\"text\":", "\"clickEvent\":")) {
                System.out.println((Object)((Object)ConsoleColor.YELLOW) + "It appears that message '" + message + "' is a JSON message, but failed to parse (" + errorMessage + ").\nIf this is a false positive add a legacy format code at the start of your message to suppress this info." + (Object)((Object)ConsoleColor.RESET));
            }
            this.legacy = true;
            try {
                MessageBuilder builder = MESSAGE_BUILDER_CONSTRUCTOR.newInstance(new Object[0]);
                builder.appendLegacy(message);
                this.json = builder.getJson();
                this.messageComponents = builder.getJsonMessageAsList();
            }
            catch (IllegalAccessException | InstantiationException | NullPointerException | InvocationTargetException e) {
                e.printStackTrace();
                this.json = "[\"\"]";
                this.messageComponents = new ArrayList<MessageComponent>(0);
            }
        }
    }

    protected Message(@NotNull Collection<? extends MessageComponent> message) {
        this.messageComponents = new ArrayList<MessageComponent>(message);
        this.fallback = this.getClassicMessage();
        this.json = MessageComponent.GSON.toJson(message);
    }

    public void setPlaceholderApiEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Placeholder API is not available for your server type!");
    }

    @NotNull
    public String getClassicMessage() {
        return this.fallback == null ? MessageComponent.getClassicMessage(this.messageComponents) : this.fallback;
    }

    @NotNull
    public MessageComponent[] getMessageComponents() {
        return this.messageComponents.toArray((MessageComponent[])Array.newInstance(MessageComponent.class, 0));
    }

    @NotNull
    public String toString() {
        return this.json;
    }

    public boolean equals(Object otherObject) {
        return this == otherObject || otherObject instanceof Message && this.json.equals(((Message)otherObject).json);
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    @NotNull
    public MESSAGE replaceAll(@NotNull @Language(value="RegExp") String regex, @NotNull String replacement) {
        this.json = this.json.replaceAll(regex, replacement);
        this.fallback = this.fallback.replaceAll(regex, replacement);
        return (MESSAGE)this;
    }

    @NotNull
    public MESSAGE placeholder(@NotNull String placeholder) {
        return (MESSAGE)this.registerPlaceholder(placeholder, null);
    }

    @NotNull
    public MESSAGE placeholder(@NotNull String placeholder, IPlaceholderProcessor placeholderProcessor) {
        return (MESSAGE)this.registerPlaceholder(placeholder, placeholderProcessor);
    }

    @NotNull
    public MESSAGE registerPlaceholder(@NotNull String placeholder, IPlaceholderProcessor placeholderProcessor) {
        return (MESSAGE)this.registerPlaceholders(new Placeholder[]{new Placeholder(placeholder, placeholderProcessor)});
    }

    @NotNull
    public MESSAGE registerPlaceholder(@NotNull String placeholder, IPlaceholderProcessor placeholderProcessor, int parameterIndex) {
        return (MESSAGE)this.registerPlaceholders(new Placeholder[]{new Placeholder(placeholder, placeholderProcessor, parameterIndex)});
    }

    @NotNull
    public MESSAGE placeholders(Placeholder ... placeholders) {
        return (MESSAGE)this.registerPlaceholders(placeholders);
    }

    @NotNull
    public MESSAGE registerPlaceholders(Placeholder ... placeholders) {
        if (this.useStringFormat) {
            this.disableStringFormat();
        }
        if (this.placeholderHandler == null) {
            this.placeholderHandler = new PlaceholderHandler(this);
        }
        this.placeholderHandler.register(placeholders);
        return (MESSAGE)this;
    }

    @NotNull
    public MESSAGE placeholders(String ... placeholderNames) {
        Placeholder[] placeholders = new Placeholder[placeholderNames.length];
        for (int i = 0; i < placeholderNames.length; ++i) {
            placeholders[i] = new Placeholder(placeholderNames[i], null, -1);
        }
        return (MESSAGE)this.registerPlaceholders(placeholders);
    }

    @NotNull
    public MESSAGE placeholderRegex(@NotNull @Language(value="RegExp") String placeholder) {
        return (MESSAGE)this.registerPlaceholderRegex(placeholder, null);
    }

    @NotNull
    public MESSAGE placeholderRegex(@NotNull @Language(value="RegExp") String placeholder, IPlaceholderProcessor placeholderProcessor) {
        return (MESSAGE)this.registerPlaceholderRegex(placeholder, placeholderProcessor);
    }

    @NotNull
    public MESSAGE registerPlaceholderRegex(@NotNull @Language(value="RegExp") String placeholder, @Nullable IPlaceholderProcessor placeholderProcessor) {
        return (MESSAGE)this.registerPlaceholders(new Placeholder[]{new Placeholder(placeholder, placeholderProcessor, true)});
    }

    @NotNull
    public MESSAGE registerPlaceholderRegex(@NotNull @Language(value="RegExp") String placeholder, IPlaceholderProcessor placeholderProcessor, int parameterIndex) {
        return (MESSAGE)this.registerPlaceholders(new Placeholder[]{new Placeholder(placeholder, placeholderProcessor, parameterIndex, true)});
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public void escapeStringFormatCharacters() {
        this.enableStringFormat();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public void enableStringFormat() {
        if (!this.useStringFormat) {
            this.replaceAll("%", "%%");
            this.useStringFormat = true;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public void disableStringFormat() {
        if (this.useStringFormat) {
            this.useStringFormat = false;
            this.replaceAll("%%", "%");
        }
    }

    protected void quoteArgs(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = StringUtils.escapeJsonString((String)args[i]);
        }
    }

    @NotNull
    public String prepareMessage(boolean useJson, Object ... args) {
        String msg;
        if (this.placeholderHandler != null) {
            if (useJson) {
                return this.placeholderHandler.format(args);
            }
            return this.placeholderHandler.formatLegacy(args);
        }
        String string = msg = useJson ? this.json : this.fallback;
        if (args != null && args.length > 0) {
            if (useJson) {
                this.quoteArgs(args);
            }
            return String.format(msg, args);
        }
        return this.useStringFormat ? msg.replaceAll("%%", "%") : msg;
    }

    @Generated
    public void setOptionalParameters(IMetadata optionalParameters) {
        this.optionalParameters = optionalParameters;
    }

    @Generated
    public IMetadata getOptionalParameters() {
        return this.optionalParameters;
    }

    @Generated
    public String getJson() {
        return this.json;
    }

    @Generated
    public String getFallback() {
        return this.fallback;
    }

    @Generated
    public boolean isPlaceholderApiEnabled() {
        return this.placeholderApiEnabled;
    }

    @Generated
    public boolean isLegacy() {
        return this.legacy;
    }
}

