/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageClickEvent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LegacyMessageParser {
    private final MessageBuilder<?, ?> builder;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final StringBuilder wordBuilder = new StringBuilder();
    private final EnumSet<MessageFormat> formats = EnumSet.noneOf(MessageFormat.class);
    private MessageColor color;
    private String url;

    LegacyMessageParser(MessageBuilder<?, ?> builder) {
        this.builder = builder;
    }

    public void parse(@NotNull String legacyMessage) {
        if (legacyMessage.length() == 0) {
            return;
        }
        this.reset();
        for (int i = 0; i < legacyMessage.length(); ++i) {
            char c = legacyMessage.charAt(i);
            if (c == '\u00a7' && i + 1 < legacyMessage.length()) {
                char formatChar;
                if (MessageColor.isColorChar(formatChar = legacyMessage.charAt(++i)) || MessageFormat.isFormatChar(formatChar) || formatChar == 'r' || formatChar == 'R') {
                    this.append();
                    this.processFormatting(formatChar);
                    continue;
                }
                if (formatChar == 'x' || formatChar == 'X') {
                    String rgbCode;
                    if (i + 12 < legacyMessage.length() && (rgbCode = this.toColorString(legacyMessage.substring(i + 1, i + 13))) != null) {
                        i += 12;
                        this.append();
                        this.color = MessageColor.valueOf(rgbCode);
                        continue;
                    }
                    if (i + 6 < legacyMessage.length() && (rgbCode = this.toColorString(legacyMessage.substring(i + 1, i + 7))) != null) {
                        i += 6;
                        this.append();
                        this.color = MessageColor.valueOf(rgbCode);
                        continue;
                    }
                    this.wordBuilder.append(c).append(formatChar);
                    continue;
                }
                this.wordBuilder.append(c).append(formatChar);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                this.endWord();
                this.stringBuilder.append(c);
                continue;
            }
            this.wordBuilder.append(c);
        }
        this.append();
    }

    private void reset() {
        this.color = null;
        this.formats.clear();
        this.url = null;
        this.stringBuilder.setLength(0);
        this.wordBuilder.setLength(0);
    }

    @Nullable
    private String toColorString(@NotNull String legacyRGB) {
        if (legacyRGB.length() == 12 && legacyRGB.matches("(\u00a7[\\da-fA-F]){6}")) {
            return '#' + legacyRGB.replaceAll("\u00a7", "");
        }
        if (legacyRGB.length() == 6 && legacyRGB.matches("[\\da-fA-F]{6}")) {
            return '#' + legacyRGB.replaceAll("\u00a7", "");
        }
        return null;
    }

    private void processFormatting(char formatChar) {
        if (formatChar == 'r' || formatChar == 'R') {
            this.color = null;
            this.formats.clear();
        } else if (MessageColor.isColorChar(formatChar)) {
            this.color = MessageColor.getFromCode(formatChar);
        } else if (MessageFormat.isFormatChar(formatChar)) {
            this.formats.add(MessageFormat.getFromCode(formatChar));
        }
    }

    private void endWord() {
        if (this.wordBuilder.length() == 0) {
            return;
        }
        String word = this.wordBuilder.toString();
        this.wordBuilder.setLength(0);
        if (StringUtils.URL_PATTERN.matcher(word).matches()) {
            this.append();
            this.url = word;
            this.append();
            return;
        }
        this.stringBuilder.append(word);
    }

    private void append() {
        if (this.wordBuilder.length() > 0) {
            this.endWord();
        }
        if (this.stringBuilder.length() == 0) {
            return;
        }
        this.builder.append(this.stringBuilder.toString(), this.color, this.formats.toArray(new MessageFormat[0]));
        if (this.url != null) {
            this.builder.onClick(MessageClickEvent.ClickEventAction.OPEN_URL, this.url);
            this.url = null;
        }
        this.stringBuilder.setLength(0);
    }
}

