/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.ILanguageConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.YamlFileUpdateMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.LanguageConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.ISendMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileManager;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YAML;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlGetter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
public class Language
extends YamlFileManager {
    private static final String MESSAGE_NOT_FOUND = "\u00a7cMessage not found!";
    private static final String KEY_LANGUAGE = "Language.";
    private static final String KEY_ADDITION_SEND_METHOD = "_SendMethod";
    private static final String KEY_ADDITION_PARAMETERS = "_Parameters";
    private static final String KEY_ADDITION_PAPI = "_PAPI";
    protected static MessageClassesReflectionDataHolder messageClasses;
    private final String prefix;
    protected String language = "en";
    protected String fallbackLanguage = "en";
    private boolean extractedFallback = false;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version) {
        this(logger, baseDir, version, File.separator + "lang", "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version, int upgradeThreshold) {
        this(logger, baseDir, version, upgradeThreshold, File.separator + "lang", "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version, @Nullable String path, @NotNull String prefix) {
        this(logger, baseDir, version, path, prefix, "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version, int upgradeThreshold, @Nullable String path, @NotNull String prefix) {
        this(logger, baseDir, version, upgradeThreshold, path, prefix, "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        this(logger, baseDir, version, 0, path, prefix, inJarPrefix);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public Language(@NotNull Logger logger, @NotNull File baseDir, int version, int upgradeThreshold, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        this(logger, baseDir, new Version(version), new Version(upgradeThreshold), path, prefix, inJarPrefix, null);
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version) {
        this(logger, baseDir, version, File.separator + "lang", "");
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version, Version upgradeThreshold) {
        this(logger, baseDir, version, upgradeThreshold, File.separator + "lang", "");
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version, @Nullable String path, @NotNull String prefix) {
        this(logger, baseDir, version, path, prefix, "");
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version, Version upgradeThreshold, @Nullable String path, @NotNull String prefix) {
        this(logger, baseDir, version, upgradeThreshold, path, prefix, "");
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        this(logger, baseDir, version, new Version(99999), path, prefix, inJarPrefix);
    }

    public Language(@NotNull Logger logger, @NotNull File baseDir, Version version, Version upgradeThreshold, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        this(logger, baseDir, version, upgradeThreshold, path, prefix, inJarPrefix, null);
    }

    private Language(@NotNull Logger logger, @NotNull File baseDir, Version version, Version upgradeThreshold, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix, @Nullable YAML yaml) {
        super(logger, baseDir, version, upgradeThreshold, path, prefix, "/lang/" + inJarPrefix, yaml);
        this.prefix = prefix;
        this.setFileDescription("language");
    }

    @NotNull
    public String get(@NotNull String path) {
        String msg = this.yaml.getString(KEY_LANGUAGE + path, MESSAGE_NOT_FOUND);
        if (msg == MESSAGE_NOT_FOUND) {
            this.logger.warning("No translation for key: " + path);
        }
        return msg;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public String getRaw(@NotNull String key, @Nullable String defaultValue) {
        return this.yaml.getString(key, defaultValue);
    }

    protected void set(@NotNull String path, @NotNull String value) {
        this.yaml.set(path, value);
    }

    public void reload() {
        this.load(this.language, this.updateMode);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public boolean load(@NotNull LanguageConfiguration config) {
        return this.load(config.getLanguage(), config.getLanguageUpdateMode());
    }

    public boolean load(@NotNull ILanguageConfiguration config) {
        return this.load(config.getLanguage(), config.getLanguageUpdateMode());
    }

    public boolean load(@NotNull String language, @NotNull String updateMode) {
        return this.load(language, at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod.fromString(updateMode));
    }

    public boolean load(@NotNull String language, @NotNull YamlFileUpdateMethod updateMode) {
        return this.load(language, at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod.valueOf(updateMode.name()), "en");
    }

    public boolean load(@NotNull String language, @NotNull at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod updateMode) {
        return this.load(language, updateMode, "en");
    }

    public boolean load(@NotNull String language, @NotNull at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod updateMode, @NotNull String fallbackLanguage) {
        this.language = language.toLowerCase(Locale.ROOT);
        this.updateMode = updateMode;
        this.fallbackLanguage = fallbackLanguage;
        this.extractedFallback = false;
        this.extracted = false;
        this.file = language + ".yml";
        this.yamlFile = new File(this.baseDir, this.prefix + this.file);
        this.load();
        return this.isLoaded();
    }

    @Override
    protected void extractFile() {
        if (this.extracted || !Utils.extractFile(this.jarClass(), this.logger, this.inJarPrefix + this.file, this.yamlFile)) {
            if (!this.language.equals(this.fallbackLanguage)) {
                Utils.extractFile(this.jarClass(), this.logger, this.inJarPrefix + this.fallbackLanguage + ".yml", this.yamlFile);
                this.extractedFallback = true;
            } else {
                this.logger.warning((Object)((Object)ConsoleColor.RED) + "Fallback language file failed to extract!" + (Object)((Object)ConsoleColor.RESET));
            }
        }
        this.extracted = true;
    }

    @Override
    @NotNull
    protected at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod decideYamlUpdateMode() {
        if (this.extractedFallback) {
            return at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod.UPDATE;
        }
        if (this.getYamlUpdateMode() != null) {
            return this.getYamlUpdateMode();
        }
        if (this.version().olderThan(new Version(this.upgradeThreshold))) {
            return at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod.UPGRADE;
        }
        return at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod.UPDATE;
    }

    @Override
    protected void doUpgrade(@NotNull YamlFileManager oldYamlFile) {
        this.logger.info("No custom " + this.getFileDescription() + " upgrade code. Copying data from old file to new one.");
        for (String key : this.yaml.getKeys()) {
            if (!oldYamlFile.yaml.isSet(key) || key.equals("Version")) continue;
            if (oldYamlFile.yaml.isList(key)) {
                this.yaml.set(key, oldYamlFile.yaml.getStringList(key, new LinkedList<String>()));
                continue;
            }
            this.yaml.set(key, oldYamlFile.yaml.getString(key, null));
            if (oldYamlFile.yaml.isSet(key + KEY_ADDITION_SEND_METHOD)) {
                this.yaml.set(key + KEY_ADDITION_SEND_METHOD, oldYamlFile.yaml.getString(key + KEY_ADDITION_SEND_METHOD, null));
            }
            if (!oldYamlFile.yaml.isSet(key + KEY_ADDITION_PARAMETERS)) continue;
            this.yaml.set(key + KEY_ADDITION_PARAMETERS, oldYamlFile.yaml.getString(key + KEY_ADDITION_PARAMETERS, null));
        }
    }

    @Nullable
    public YAML getLang() {
        return this.getYaml();
    }

    @NotNull
    public YAML getLangE() throws LanguageNotInitializedException {
        if (this.yaml == null) {
            throw new LanguageNotInitializedException();
        }
        return this.yaml;
    }

    @NotNull
    public YamlGetter getLangReadOnly() throws LanguageNotInitializedException {
        return this.getLangE();
    }

    @NotNull
    public String getTranslated(@NotNull String path) {
        return this.translateColorCodes(this.get(path));
    }

    @NotNull
    public String translateColorCodes(@NotNull String string) {
        return MessageColor.translateAlternateColorAndFormatCodes(string);
    }

    @Nullable
    protected <T extends Message> T getMessage(boolean escapeStringFormatCharacters, @NotNull String path) {
        if (messageClasses == null) {
            this.logger.warning((Object)((Object)ConsoleColor.RED) + "Message reflection data object not set!" + (Object)((Object)ConsoleColor.RESET));
            return null;
        }
        Message msg = null;
        try {
            String msgString = this.getTranslated(path);
            msg = (Message)Language.messageClasses.messageConstructor.newInstance(msgString);
            if (msgString.isEmpty()) {
                Language.messageClasses.setSendMethod.invoke((Object)msg, Enum.valueOf(Language.messageClasses.enumType, "DISABLED"));
                return (T)msg;
            }
            if (escapeStringFormatCharacters) {
                msg.escapeStringFormatCharacters();
            }
            String pathSendMethod = KEY_LANGUAGE + path + KEY_ADDITION_SEND_METHOD;
            String pathParameter = KEY_LANGUAGE + path + KEY_ADDITION_PARAMETERS;
            if (this.yaml.isSet(pathSendMethod)) {
                String sendMethodName = this.yaml.getString(pathSendMethod, "CHAT").toUpperCase(Locale.ROOT);
                Object sendMethod = null;
                try {
                    sendMethod = Enum.valueOf(Language.messageClasses.enumType, sendMethodName);
                }
                catch (IllegalArgumentException ignored) {
                    this.logger.warning((Object)((Object)ConsoleColor.RED) + "Unknown send method '" + sendMethodName + "' for message " + KEY_LANGUAGE + path + (Object)((Object)ConsoleColor.RESET));
                }
                if (sendMethod instanceof ISendMethod) {
                    IMetadata meta;
                    Language.messageClasses.setSendMethod.invoke((Object)msg, sendMethod);
                    if (this.yaml.isSet(pathParameter) && (meta = ((ISendMethod)sendMethod).parseMetadata(this.yaml.getString(pathParameter))) != null) {
                        msg.setOptionalParameters(meta);
                    }
                }
            }
            if (this.yaml.getBoolean(KEY_LANGUAGE + path + KEY_ADDITION_PAPI, false)) {
                try {
                    msg.setPlaceholderApiEnabled(true);
                }
                catch (UnsupportedOperationException e) {
                    this.logger.warning((Object)((Object)ConsoleColor.RED) + e.getMessage() + (Object)((Object)ConsoleColor.RESET));
                }
            }
        }
        catch (Exception e) {
            if (msg == null) {
                this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to load message: " + KEY_LANGUAGE + path + " " + (Object)((Object)ConsoleColor.RESET));
            } else {
                this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed generate metadata for: " + KEY_LANGUAGE + path + " " + (Object)((Object)ConsoleColor.RESET));
            }
            e.printStackTrace();
        }
        return (T)msg;
    }

    @NotNull
    public String getLanguage() {
        return this.getLang().getString("LanguageName", this.language);
    }

    @NotNull
    public String getAuthor() {
        return this.getLang().getString("Author", "Unknown");
    }

    @Override
    protected void loaded() {
        String author = this.getAuthor().equals("Unknown") ? "" : "  Author: " + this.getAuthor();
        this.logger.info((Object)((Object)ConsoleColor.GREEN) + this.getFileDescriptionCapitalized() + " file successfully loaded. Language: " + this.getLanguage() + author + (Object)((Object)ConsoleColor.RESET));
    }

    public static class LanguageNotInitializedException
    extends RuntimeException {
        private LanguageNotInitializedException() {
            super("The language file has not been loaded successful");
        }
    }

    protected static class MessageClassesReflectionDataHolder {
        public Class enumType;
        public Method setSendMethod;
        public Constructor<?> messageConstructor;

        public MessageClassesReflectionDataHolder(Constructor<?> messageConstructor, Method setSendMethod, Class<? extends ISendMethod> enumType) {
            this.enumType = enumType;
            this.setSendMethod = setSendMethod;
            this.messageConstructor = messageConstructor;
        }
    }
}

