/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.DBTools;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.UpdateDataUUID;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.UUIDConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

class UUIDValidator {
    public static final String MESSAGE_UPDATE_UUIDS = "Start updating database to UUIDs ...";
    public static final String MESSAGE_UPDATED_UUIDS = "Updated %d accounts to UUIDs.";
    @NotNull
    private final Logger logger;
    @NotNull
    private final Connection connection;
    @NotNull
    private final String tableName;
    @NotNull
    private final String nameColumnName;
    @NotNull
    private final String uuidColumnName;
    @NotNull
    private final String idColumnName;
    private final boolean useUuidSeparators;
    private final boolean useOnlineUUIDs;
    private final Map<String, UpdateDataUUID> toConvert = new TreeMap<String, UpdateDataUUID>(String.CASE_INSENSITIVE_ORDER);
    private final List<UpdateDataUUID> toUpdate = new ArrayList<UpdateDataUUID>();

    private void collectUuidsThatNeedFixing() throws SQLException {
        this.toConvert.clear();
        this.toUpdate.clear();
        String queryGetUnsetOrInvalidUUIDs = "SELECT `" + this.idColumnName + "`,`" + this.nameColumnName + "`,`" + this.uuidColumnName + "` FROM `" + this.tableName + "` WHERE `" + this.uuidColumnName + "` IS NULL OR `" + this.uuidColumnName + "` " + (this.useUuidSeparators ? "NOT LIKE '%-%-%-%-%'" : "LIKE '%-%'") + ";";
        try (Statement stmt = this.connection.createStatement();
             ResultSet res = stmt.executeQuery(queryGetUnsetOrInvalidUUIDs);){
            while (res.next()) {
                String uuid;
                if (res.isFirst()) {
                    this.logger.info(MESSAGE_UPDATE_UUIDS);
                }
                if ((uuid = res.getString(this.uuidColumnName)) == null) {
                    this.toConvert.put(res.getString(this.nameColumnName), new UpdateDataUUID(res.getString(this.nameColumnName), null, res.getInt(this.idColumnName)));
                    continue;
                }
                this.toUpdate.add(new UpdateDataUUID(res.getString(this.nameColumnName), uuid, res.getInt(this.idColumnName)));
            }
        }
    }

    void convertNamesToUuids() {
        if (!this.toConvert.isEmpty()) {
            Map<String, String> newUUIDs = UUIDConverter.getUUIDsFromNames(this.toConvert.keySet(), this.useOnlineUUIDs, this.useUuidSeparators);
            for (Map.Entry<String, String> entry : newUUIDs.entrySet()) {
                UpdateDataUUID updateData = this.toConvert.get(entry.getKey());
                updateData.setUuid(entry.getValue());
                this.toUpdate.add(updateData);
            }
        }
    }

    void writeUpdatedUuids() throws SQLException {
        String queryFixUUIDs = "UPDATE `" + this.tableName + "` SET `" + this.uuidColumnName + "`=? WHERE `" + this.idColumnName + "`=?;";
        boolean ok = false;
        do {
            try (PreparedStatement ps = this.connection.prepareStatement(queryFixUUIDs);){
                for (UpdateDataUUID updateData : this.toUpdate) {
                    DBTools.setParameters(ps, updateData.formatUuid(this.useUuidSeparators), updateData.getId());
                    ps.addBatch();
                }
                ps.executeBatch();
                ok = true;
            }
            catch (SQLException ignored) {
                this.handleDuplicatedUuids();
            }
        } while (!ok);
    }

    void handleDuplicatedUuids() throws SQLException {
        String queryLoadPlayer = "SELECT * FROM `" + this.tableName + "` WHERE `" + this.uuidColumnName + "`=?;";
        Iterator<UpdateDataUUID> updateUUIDsHelperIterator = this.toUpdate.iterator();
        while (updateUUIDsHelperIterator.hasNext()) {
            UpdateDataUUID updateData = updateUUIDsHelperIterator.next();
            PreparedStatement ps = this.connection.prepareStatement(queryLoadPlayer);
            try {
                ps.setString(1, updateData.formatUuid(this.useUuidSeparators));
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) continue;
                    this.logger.warning("User " + updateData.getName() + " (db id: " + updateData.getId() + ") has the same UUID as " + rs.getString(this.nameColumnName) + " (db id: " + rs.getInt(this.idColumnName) + "), UUID: " + updateData.getUuid());
                    updateUUIDsHelperIterator.remove();
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (ps == null) continue;
                ps.close();
            }
        }
    }

    public void validateUUIDs() throws SQLException {
        this.collectUuidsThatNeedFixing();
        if (!this.toConvert.isEmpty() || !this.toUpdate.isEmpty()) {
            this.convertNamesToUuids();
            this.writeUpdatedUuids();
            this.logger.info(String.format(MESSAGE_UPDATED_UUIDS, this.toUpdate.size()));
        }
    }

    @Generated
    public UUIDValidator(@NotNull Logger logger, @NotNull Connection connection, @NotNull String tableName, @NotNull String nameColumnName, @NotNull String uuidColumnName, @NotNull String idColumnName, boolean useUuidSeparators, boolean useOnlineUUIDs) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (nameColumnName == null) {
            throw new NullPointerException("nameColumnName is marked non-null but is null");
        }
        if (uuidColumnName == null) {
            throw new NullPointerException("uuidColumnName is marked non-null but is null");
        }
        if (idColumnName == null) {
            throw new NullPointerException("idColumnName is marked non-null but is null");
        }
        this.logger = logger;
        this.connection = connection;
        this.tableName = tableName;
        this.nameColumnName = nameColumnName;
        this.uuidColumnName = uuidColumnName;
        this.idColumnName = idColumnName;
        this.useUuidSeparators = useUuidSeparators;
        this.useOnlineUUIDs = useOnlineUUIDs;
    }
}

