/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SQLTableValidator {
    private static final Pattern CURRENT_TABLE_INFO = Pattern.compile("^\\w*(CREATE TABLE)( IF NOT EXISTS)?\\s+(`(?<tableNameEsc>\\w+)`|(?<tableName>\\w+))\\s+\\(\\n(?<columns>[\\s\\S]*)\\n\\)(?<engine>\\s+ENGINE=\\w+)?(\\s+AUTO_INCREMENT=\\d+)?(\\s+DEFAULT\\s+CHARSET=(?<charset>\\w+))?;?$", 2);
    private static final Pattern COLUMN_NAME_EXTRACTOR_PATTERN = Pattern.compile("^(`([^`]+)`|\\w+) (.*)$", 2);
    private static final Pattern COLUMN_CONSTRAINT_CHECKER_PATTERN = Pattern.compile("^(CONSTRAINT\\s*(`(\\w*)`|\\w*)\\s+)?(PRIMARY KEY|UNIQUE KEY|UNIQUE INDEX|FOREIGN KEY)\\s+(.*)$", 2);
    private static final Pattern COLUMN_KEY_CHECKER_PATTERN = Pattern.compile("^(INDEX|KEY)\\s+(`(\\w*)`|(\\w*))?\\s?\\(((`\\w*`|\\w*)(,\\s*(`\\w*`|\\w*))*)\\)$", 2);
    private static final Pattern COLUMN_TYPE_EXTRACTOR_PATTERN = Pattern.compile("^(\\w*(\\(\\d+(,\\d+)?\\))?)\\s+(.*)$", 2);
    private static final Pattern UNIQUE_INDEX_PATTERN = Pattern.compile("^(`(\\w+)`|\\w+)?\\s*\\((.*)\\)$", 2);
    private static final Pattern FOREIGN_KEY_PATTERN = Pattern.compile("^(`(\\w+)`|\\w+)?\\s*\\(([^)]*)\\)\\s+REFERENCES\\s+(`\\w+`|\\w+)\\s+\\(([^)]*)\\)\\s*(ON DELETE (RESTRICT|CASCADE|SET NULL|NO ACTION))?\\s*(ON UPDATE (RESTRICT|CASCADE|SET NULL|NO ACTION))?$", 2);
    private static final Pattern QUERY_END = Pattern.compile("\\)(?<engine>\\s+ENGINE=\\w+)?\\s*;?$", 2);
    private static final Pattern QUERY_BEGIN = Pattern.compile("^\\w*(CREATE TABLE IF NOT EXISTS|CREATE TABLE)\\s+(`(\\w+)`|\\w+)\\s+\\(", 2);

    public void validate(@NotNull Connection connection, @NotNull @Language(value="SQL") String tableDefinition) throws IllegalArgumentException, SQLException {
        this.validate(connection, tableDefinition, null);
    }

    public void validate(@NotNull Connection connection, @NotNull @Language(value="SQL") String tableDefinition, @Nullable Logger logger) throws IllegalArgumentException, SQLException {
        List<String> currentTableColumns;
        String currentCreateStatement;
        String tableName;
        Matcher definitionTableInfoMatch = CURRENT_TABLE_INFO.matcher(tableDefinition = tableDefinition.trim());
        if (!definitionTableInfoMatch.find()) {
            if ((tableDefinition = SQLTableValidator.reformatTableDefinition(tableDefinition)) != null) {
                definitionTableInfoMatch = CURRENT_TABLE_INFO.matcher(tableDefinition);
            }
            if (!definitionTableInfoMatch.find()) {
                throw new IllegalArgumentException("Invalid format of create query detected!");
            }
        }
        if ((tableName = definitionTableInfoMatch.group("tableNameEsc")) == null) {
            tableName = definitionTableInfoMatch.group("tableName");
        }
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid format of create query detected!");
        }
        String[] definitionTableColumns = definitionTableInfoMatch.group("columns").split(",\n\\s?");
        try {
            currentCreateStatement = this.getCurrentCreateStatement(connection, tableName);
            currentTableColumns = this.getCurrentTableColumns(currentCreateStatement);
        }
        catch (SQLException ignored) {
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(tableDefinition);
            }
            return;
        }
        try {
            for (int i = 0; i < definitionTableColumns.length; ++i) {
                definitionTableColumns[i] = definitionTableColumns[i].trim().replaceAll("\\s+", " ");
                Matcher columnMatcher = COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(definitionTableColumns[i]);
                if (columnMatcher.find()) {
                    this.processConstraint(connection, columnMatcher, tableName, definitionTableColumns[i], currentTableColumns);
                    continue;
                }
                columnMatcher = COLUMN_KEY_CHECKER_PATTERN.matcher(definitionTableColumns[i]);
                if (columnMatcher.find()) {
                    this.processKey(connection, columnMatcher, tableName, definitionTableColumns[i], currentTableColumns);
                    continue;
                }
                columnMatcher = COLUMN_NAME_EXTRACTOR_PATTERN.matcher(definitionTableColumns[i]);
                if (!columnMatcher.find()) continue;
                this.processName(connection, columnMatcher, tableName, definitionTableColumns[i], currentTableColumns);
            }
        }
        catch (SQLException e) {
            if (logger != null) {
                logger.severe("Failed to update table definition for " + tableName + "!\nCurrent table layout:\n" + currentCreateStatement + "\nRequested table layout:\n" + tableDefinition);
            }
            throw e;
        }
    }

    protected List<String> getCurrentTableColumns(@NotNull @Language(value="SQL") String currentCreateStatement) throws SQLException {
        LinkedList<String> currentTableColumns = new LinkedList<String>();
        if (!CURRENT_TABLE_INFO.matcher(currentCreateStatement).matches()) {
            currentCreateStatement = SQLTableValidator.reformatTableDefinition(currentCreateStatement);
        }
        if (currentCreateStatement == null || currentCreateStatement.isEmpty()) {
            throw new SQLException();
        }
        Collections.addAll(currentTableColumns, currentCreateStatement.split("(,|^\\()?\n\\s*"));
        currentTableColumns.remove(0);
        currentTableColumns.remove(currentTableColumns.size() - 1);
        return currentTableColumns;
    }

    /*
     * Unable to fully structure code
     */
    protected void processConstraint(@NotNull Connection connection, @NotNull Matcher columnMatcher, @NotNull String tableName, @NotNull String definitionColumn, @NotNull List<String> currentTableColumns) throws SQLException {
        columnName = columnMatcher.group(3) == null ? (columnMatcher.group(2) == null ? "" : columnMatcher.group(2)) : columnMatcher.group(3);
        keyExists = false;
        update = false;
        var17_9 = columnMatcher.group(4).toUpperCase(Locale.ROOT);
        var18_10 = -1;
        switch (var17_9.hashCode()) {
            case 1284802305: {
                if (!var17_9.equals("PRIMARY KEY")) break;
                var18_10 = 0;
                break;
            }
            case 2027479971: {
                if (!var17_9.equals("UNIQUE INDEX")) break;
                var18_10 = 1;
                break;
            }
            case 976412016: {
                if (!var17_9.equals("UNIQUE KEY")) break;
                var18_10 = 2;
                break;
            }
            case 704200915: {
                if (!var17_9.equals("FOREIGN KEY")) break;
                var18_10 = 3;
            }
        }
        switch (var18_10) {
            case 0: {
                createKeyArray = columnMatcher.group(5).replaceAll("[`()]", "").split(",\\s*");
                currentTableColumnsIterator = currentTableColumns.iterator();
                block11: while (currentTableColumnsIterator.hasNext()) {
                    currentMatcher = SQLTableValidator.COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                    if (!currentMatcher.find() || !currentMatcher.group(4).equalsIgnoreCase("PRIMARY KEY")) continue;
                    keyExists = true;
                    currentTableColumnsIterator.remove();
                    tempArray = currentMatcher.group(5).replaceAll("[`()]", "").split(",\\s*");
                    if (createKeyArray.length != tempArray.length) {
                        update = true;
                        break;
                    }
                    for (index = 0; index < createKeyArray.length; ++index) {
                        if (createKeyArray[index].equalsIgnoreCase(tempArray[index])) continue;
                        update = true;
                        break block11;
                    }
                }
                if (!keyExists) {
                    this.addPrimaryKey(connection, tableName, columnMatcher.group(5));
                    break;
                }
                if (!update) break;
                this.modifyPrimaryKey(connection, tableName, columnMatcher.group(5));
                break;
            }
            case 1: 
            case 2: {
                tempKeyMatcher = SQLTableValidator.UNIQUE_INDEX_PATTERN.matcher(columnMatcher.group(5));
                if (!tempKeyMatcher.find()) ** GOTO lbl91
                if (columnName.length() == 0) {
                    columnName = tempKeyMatcher.group(2) == null ? tempKeyMatcher.group(1) : tempKeyMatcher.group(2);
                }
                createKeyArray = tempKeyMatcher.group(3).replace("`", "").split(",\\s*");
                currentTableColumnsIterator = currentTableColumns.iterator();
                if (columnName != null) ** GOTO lbl69
                while (currentTableColumnsIterator.hasNext()) {
                    currentMatcher = SQLTableValidator.COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                    if (!currentMatcher.find() || !currentMatcher.group(4).equalsIgnoreCase("UNIQUE INDEX") && !currentMatcher.group(4).equalsIgnoreCase("UNIQUE KEY")) continue;
                    keyExists = true;
                    if (!(currentMatcher = SQLTableValidator.UNIQUE_INDEX_PATTERN.matcher(currentMatcher.group(5))).find()) continue;
                    tempArray = currentMatcher.group(3).replace("`", "").split(",\\s*");
                    if (createKeyArray.length != tempArray.length) {
                        keyExists = false;
                        continue;
                    }
                    for (index = 0; index < createKeyArray.length; ++index) {
                        if (createKeyArray[index].equalsIgnoreCase(tempArray[index])) continue;
                        keyExists = false;
                        break;
                    }
                    if (!keyExists) continue;
                    ** GOTO lbl92
                }
                ** GOTO lbl92
lbl69:
                // 1 sources

                update = false;
                block15: while (currentTableColumnsIterator.hasNext()) {
                    currentMatcher = SQLTableValidator.COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                    if (!currentMatcher.find() || !currentMatcher.group(4).equalsIgnoreCase("UNIQUE INDEX") && !currentMatcher.group(4).equalsIgnoreCase("UNIQUE KEY")) continue;
                    v0 = columnMatcher.group(3) == null ? (columnMatcher.group(2) == null ? "" : columnMatcher.group(2)) : (tempValue = columnMatcher.group(3));
                    if (!(currentMatcher = SQLTableValidator.UNIQUE_INDEX_PATTERN.matcher(currentMatcher.group(5))).find()) continue;
                    if (tempValue.length() == 0) {
                        v1 = tempValue = currentMatcher.group(2) == null ? currentMatcher.group(1) : currentMatcher.group(2);
                    }
                    if (tempValue == null || !tempValue.equalsIgnoreCase(columnName)) continue;
                    keyExists = true;
                    currentTableColumnsIterator.remove();
                    tempArray = currentMatcher.group(3).replace("`", "").split(",\\s*");
                    if (createKeyArray.length != tempArray.length) {
                        update = true;
                        break;
                    }
                    for (index = 0; index < createKeyArray.length; ++index) {
                        if (createKeyArray[index].equalsIgnoreCase(tempArray[index])) continue;
                        update = true;
                        break block15;
                    }
                }
                if (update) {
                    this.makeIndexUnique(connection, tableName, columnName, tempKeyMatcher.group(3));
                }
                ** GOTO lbl92
lbl91:
                // 1 sources

                throw new IllegalArgumentException("Invalid format of create query detected - invalid unique index definition!");
lbl92:
                // 3 sources

                if (keyExists) break;
                this.addUniqueIndex(connection, tableName, columnName, tempKeyMatcher.group(3));
                break;
            }
            case 3: {
                tempKeyMatcher = SQLTableValidator.FOREIGN_KEY_PATTERN.matcher(columnMatcher.group(5));
                if (!tempKeyMatcher.find()) {
                    throw new IllegalArgumentException("Invalid format of create query detected - invalid reference detected!");
                }
                if (columnName.length() == 0) {
                    v2 = columnName = tempKeyMatcher.group(2) == null ? tempKeyMatcher.group(1) : tempKeyMatcher.group(2);
                }
                if ((createKeyArray = tempKeyMatcher.group(3).replace("`", "").split(",\\s*")).length != (tempArray = tempKeyMatcher.group(5).replace("`", "").split(",\\s*")).length) {
                    throw new IllegalArgumentException("Invalid format of create query detected - invalid reference detected!");
                }
                currentTableColumnsIterator = currentTableColumns.iterator();
                if (columnName != null) ** GOTO lbl139
                while (currentTableColumnsIterator.hasNext()) {
                    currentMatcher = SQLTableValidator.COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                    if (!currentMatcher.find() || !currentMatcher.group(4).equalsIgnoreCase("FOREIGN KEY")) continue;
                    keyExists = true;
                    if (!(currentMatcher = SQLTableValidator.FOREIGN_KEY_PATTERN.matcher(currentMatcher.group(5))).find()) continue;
                    currentReferenceColumns = currentMatcher.group(3).replace("`", "").split(",\\s*");
                    if (currentReferenceColumns.length != (currentTargetColumns = currentMatcher.group(5).replace("`", "").split(",\\s*")).length) {
                        throw new IllegalArgumentException("Invalid format of create query detected - invalid reference detected!");
                    }
                    if (createKeyArray.length != currentReferenceColumns.length) {
                        keyExists = false;
                        continue;
                    }
                    if (currentMatcher.group(7) != null) {
                        if (tempKeyMatcher.group(7) == null || !currentMatcher.group(7).equalsIgnoreCase(tempKeyMatcher.group(7))) {
                            keyExists = false;
                            continue;
                        }
                    } else if (tempKeyMatcher.group(7) != null) {
                        keyExists = false;
                        continue;
                    }
                    if (currentMatcher.group(9) != null) {
                        if (tempKeyMatcher.group(9) == null || !currentMatcher.group(9).equalsIgnoreCase(tempKeyMatcher.group(9))) {
                            keyExists = false;
                            continue;
                        }
                    } else if (tempKeyMatcher.group(9) != null) {
                        keyExists = false;
                        continue;
                    }
                    for (index = 0; index < createKeyArray.length; ++index) {
                        if (createKeyArray[index].equalsIgnoreCase(currentReferenceColumns[index]) && tempArray[index].equalsIgnoreCase(currentTargetColumns[index])) continue;
                        keyExists = false;
                        break;
                    }
                    if (!keyExists) continue;
                    ** GOTO lbl176
                }
                ** GOTO lbl176
lbl139:
                // 1 sources

                update = false;
                while (currentTableColumnsIterator.hasNext()) {
                    currentMatcher = SQLTableValidator.COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                    if (!currentMatcher.find() || !currentMatcher.group(4).equalsIgnoreCase("FOREIGN KEY")) continue;
                    v3 = tempValue = currentMatcher.group(3) == null ? currentMatcher.group(2) : currentMatcher.group(3);
                    if (!(currentMatcher = SQLTableValidator.FOREIGN_KEY_PATTERN.matcher(currentMatcher.group(5))).find()) continue;
                    if (tempValue.length() == 0) {
                        v4 = tempValue = currentMatcher.group(2) == null ? currentMatcher.group(1) : currentMatcher.group(2);
                    }
                    if (tempValue == null || !tempValue.equalsIgnoreCase(columnName)) continue;
                    keyExists = true;
                    currentTableColumnsIterator.remove();
                    currentReferenceColumns = currentMatcher.group(3).replace("`", "").split(",\\s*");
                    currentTargetColumns = currentMatcher.group(5).replace("`", "").split(",\\s*");
                    if (currentReferenceColumns.length != currentTargetColumns.length) {
                        throw new IllegalArgumentException("Invalid format of create query detected - invalid reference detected!");
                    }
                    if (createKeyArray.length != currentReferenceColumns.length) {
                        update = true;
                        break;
                    }
                    for (index = 0; index < createKeyArray.length; ++index) {
                        if (createKeyArray[index].equalsIgnoreCase(currentReferenceColumns[index]) && tempArray[index].equalsIgnoreCase(currentTargetColumns[index])) continue;
                        update = true;
                        break;
                    }
                    if (currentMatcher.group(7) != null) {
                        if (tempKeyMatcher.group(7) == null || !currentMatcher.group(7).equalsIgnoreCase(tempKeyMatcher.group(7))) {
                            update = true;
                        }
                    } else if (tempKeyMatcher.group(7) != null && !tempKeyMatcher.group(7).equalsIgnoreCase("RESTRICT") && !tempKeyMatcher.group(7).equalsIgnoreCase("NO ACTION")) {
                        update = true;
                    }
                    if (currentMatcher.group(9) != null) {
                        if (tempKeyMatcher.group(9) != null && currentMatcher.group(9).equalsIgnoreCase(tempKeyMatcher.group(9))) break;
                        update = true;
                        break;
                    }
                    if (tempKeyMatcher.group(9) == null) break;
                    update = true;
                    break;
                }
                if (update) {
                    this.modifyConstraint(connection, tableName, columnName, tempKeyMatcher.group(3), tempKeyMatcher.group(4) + " (" + tempKeyMatcher.group(5) + ") " + (tempKeyMatcher.group(6) == null ? "" : tempKeyMatcher.group(6) + " ") + (tempKeyMatcher.group(8) == null ? "" : tempKeyMatcher.group(8)));
                }
lbl176:
                // 5 sources

                if (keyExists) break;
                this.addConstraint(connection, tableName, columnName, tempKeyMatcher.group(3), tempKeyMatcher.group(4) + " (" + tempKeyMatcher.group(5) + ") " + (tempKeyMatcher.group(6) == null ? "" : tempKeyMatcher.group(6) + " ") + (tempKeyMatcher.group(8) == null ? "" : tempKeyMatcher.group(8)));
            }
        }
    }

    protected void processKey(@NotNull Connection connection, @NotNull Matcher columnMatcher, @NotNull String tableName, @NotNull String definitionColumn, @NotNull List<String> currentTableColumns) throws SQLException {
        String columnName = columnMatcher.group(3) == null ? columnMatcher.group(2) : columnMatcher.group(3);
        boolean keyExists = false;
        boolean update = false;
        String[] createKeyArray = columnMatcher.group(5).replaceAll("[`\\s]", "").split(",");
        if (columnName.length() > 0) {
            Iterator<String> currentTableColumnsIterator = currentTableColumns.iterator();
            block0: while (currentTableColumnsIterator.hasNext()) {
                Matcher tempKeyMatcher = COLUMN_KEY_CHECKER_PATTERN.matcher(currentTableColumnsIterator.next());
                if (!tempKeyMatcher.find() || !(tempKeyMatcher.group(3) == null ? tempKeyMatcher.group(2) : tempKeyMatcher.group(3)).equalsIgnoreCase(columnName)) continue;
                currentTableColumnsIterator.remove();
                keyExists = true;
                String[] tempArray = tempKeyMatcher.group(5).replace("`", "").split(",\\s*");
                if (tempArray.length != createKeyArray.length) {
                    update = true;
                    break;
                }
                for (int i = 0; i < createKeyArray.length; ++i) {
                    if (createKeyArray[i].equalsIgnoreCase(tempArray[i])) continue;
                    update = true;
                    break block0;
                }
            }
            if (update) {
                this.modifyIndex(connection, tableName, columnName, columnMatcher.group(5));
                return;
            }
        } else {
            block2: for (String currentTableColumn : currentTableColumns) {
                String[] tempArray;
                Matcher tempKeyMatcher = COLUMN_KEY_CHECKER_PATTERN.matcher(currentTableColumn);
                if (!tempKeyMatcher.find() || (tempArray = tempKeyMatcher.group(5).replaceAll("[`\\s]", "").split(",")).length != createKeyArray.length) continue;
                for (int i = 0; i < createKeyArray.length; ++i) {
                    if (!createKeyArray[i].equalsIgnoreCase(tempArray[i])) continue;
                    keyExists = true;
                    continue block2;
                }
            }
        }
        if (!keyExists) {
            this.addIndex(connection, tableName, columnName, columnMatcher.group(5));
        }
    }

    protected void processName(@NotNull Connection connection, @NotNull Matcher columnMatcher, @NotNull String tableName, @NotNull String definitionColumn, @NotNull List<String> currentTableColumns) throws SQLException {
        String columnName = columnMatcher.group(2) == null ? columnMatcher.group(1) : columnMatcher.group(2);
        boolean keyExists = false;
        boolean update = true;
        Iterator<String> currentTableColumnsIterator = currentTableColumns.iterator();
        while (currentTableColumnsIterator.hasNext()) {
            Matcher tempKeyMatcher;
            String tempValue = currentTableColumnsIterator.next();
            if (COLUMN_CONSTRAINT_CHECKER_PATTERN.matcher(tempValue).find() || COLUMN_KEY_CHECKER_PATTERN.matcher(tempValue).find() || !(tempKeyMatcher = COLUMN_NAME_EXTRACTOR_PATTERN.matcher(tempValue)).find() || !(tempKeyMatcher.group(2) == null ? tempKeyMatcher.group(1) : tempKeyMatcher.group(2)).equalsIgnoreCase(columnName)) continue;
            currentTableColumnsIterator.remove();
            keyExists = true;
            if (columnMatcher.group(3).equalsIgnoreCase(tempKeyMatcher.group(3))) continue;
            Matcher currentMatcher = COLUMN_TYPE_EXTRACTOR_PATTERN.matcher(tempKeyMatcher.group(3));
            tempKeyMatcher = COLUMN_TYPE_EXTRACTOR_PATTERN.matcher(columnMatcher.group(3));
            if (currentMatcher.find() && tempKeyMatcher.find() && currentMatcher.group(1).equalsIgnoreCase(tempKeyMatcher.group(1))) {
                LinkedList<String> currentFlags = new LinkedList<String>(Arrays.asList(currentMatcher.group(4).split("\\s+")));
                for (String flag : tempKeyMatcher.group(4).split("\\s+")) {
                    update = true;
                    Iterator currentFlagsIterator = currentFlags.iterator();
                    while (currentFlagsIterator.hasNext()) {
                        tempValue = (String)currentFlagsIterator.next();
                        if (!flag.equalsIgnoreCase(tempValue)) continue;
                        update = false;
                        currentFlagsIterator.remove();
                        break;
                    }
                    if (update) break;
                }
            }
            if (!update) continue;
            this.modifyColumn(connection, tableName, columnName, columnMatcher.group(3));
        }
        if (!keyExists) {
            this.addColumn(connection, tableName, columnName, columnMatcher.group(3));
        }
    }

    protected abstract String getCurrentCreateStatement(@NotNull Connection var1, @NotNull String var2) throws SQLException;

    protected abstract void addColumn(Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract void modifyColumn(Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract void addIndex(@NotNull Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract void modifyIndex(@NotNull Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract void makeIndexUnique(@NotNull Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract void addUniqueIndex(@NotNull Connection var1, String var2, @Nullable String var3, String var4) throws SQLException;

    protected abstract void addConstraint(@NotNull Connection var1, String var2, String var3, String var4, String var5) throws SQLException;

    protected abstract void modifyConstraint(@NotNull Connection var1, String var2, String var3, String var4, String var5) throws SQLException;

    protected abstract void addPrimaryKey(@NotNull Connection var1, String var2, String var3) throws SQLException;

    protected abstract void modifyPrimaryKey(@NotNull Connection var1, String var2, String var3) throws SQLException;

    protected static String reformatTableDefinition(@Language(value="SQL") String query) {
        Matcher tempMatcher = QUERY_END.matcher(query = query.replace("\r", "").replace("\n", " "));
        if (!tempMatcher.find()) {
            return null;
        }
        String temp = tempMatcher.group("engine");
        query = tempMatcher.replaceAll("");
        String queryEnd = ")" + (temp != null ? temp : "") + ";";
        tempMatcher = QUERY_BEGIN.matcher(query);
        if (!tempMatcher.find()) {
            return null;
        }
        String queryBegin = tempMatcher.group();
        query = tempMatcher.replaceAll("").trim();
        return queryBegin + "\n" + query.replaceAll(",(?=([^\"'`]*[\"'`][^\"'`]*[\"'`])*[^\"'`]*$)", ",\n").replaceAll("(,\\n)(?=[^(]*?\\))", ",") + "\n" + queryEnd;
    }
}

