/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.IConfig;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface DatabaseConnectionConfiguration
extends IConfig {
    @NotNull
    default public String getSQLHost() {
        return this.getConfigE().getString("Database.SQL.Host", "localhost:3306");
    }

    @NotNull
    default public String getSQLDatabase() {
        return this.getConfigE().getString("Database.SQL.Database", "minecraft");
    }

    @NotNull
    default public List<String> getSQLConnectionPropertiesList() {
        return this.getConfigE().getStringList("Database.SQL.Properties", new ArrayList<String>());
    }

    @NotNull
    default public String getSQLConnectionProperties() {
        List<String> list = this.getSQLConnectionPropertiesList();
        StringBuilder str = new StringBuilder();
        int separator = 63;
        for (String s : list) {
            str.append((char)separator).append(s);
            separator = 38;
        }
        return str.toString();
    }

    @NotNull
    default public String getSQLUser() {
        return this.getConfigE().getString("Database.SQL.User", "minecraft");
    }

    @NotNull
    default public String getSQLPassword() {
        return this.getConfigE().getString("Database.SQL.Password", "minecraft");
    }

    default public int getSQLMaxConnections() {
        return Math.max(1, this.getConfigE().getInt("Database.SQL.MaxConnections", 2));
    }

    default public long getSQLMaxLifetime() {
        return this.getConfigE().getLong("Database.SQL.MaxLifetime", -1L) * 1000L;
    }

    default public long getSQLIdleTimeout() {
        return this.getConfigE().getLong("Database.SQL.IdleTimeout", -1L) * 1000L;
    }
}

