/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.MySQLTableValidator;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.SQLiteTableValidator;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.UUIDValidator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DBTools {
    public static void updateDB(@NotNull Connection connection, @NotNull @Language(value="SQL") String tableDefinition, @Nullable Logger logger) throws IllegalArgumentException, SQLException {
        String dbType = connection.getMetaData().getDatabaseProductName();
        switch (dbType.toLowerCase(Locale.ENGLISH)) {
            case "mysql": 
            case "mariadb": {
                new MySQLTableValidator().validate(connection, tableDefinition);
                return;
            }
            case "sqlite": {
                new SQLiteTableValidator().validate(connection, tableDefinition);
                return;
            }
        }
        throw new RuntimeException("Unsupported database backend '" + dbType + "'!");
    }

    public static void updateDB(@NotNull Connection connection, @NotNull @Language(value="SQL") String tableDefinition) throws IllegalArgumentException, SQLException {
        DBTools.updateDB(connection, tableDefinition, null);
    }

    public static void runStatement(@NotNull Connection connection, @NotNull @Language(value="SQL") String query, Object ... args) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            DBTools.setParameters(preparedStatement, args);
            preparedStatement.execute();
        }
    }

    public static void runStatementWithoutException(@NotNull Connection connection, @NotNull @Language(value="SQL") String query, Object ... args) {
        try {
            DBTools.runStatement(connection, query, args);
        }
        catch (SQLException e) {
            System.out.println("\nQuery: " + query + "\nData: " + Arrays.toString(args));
            e.printStackTrace();
        }
    }

    public static void runStatementWithoutException(@NotNull Connection connection, @NotNull Logger logger, @NotNull @Language(value="SQL") String query, Object ... args) {
        try {
            DBTools.runStatement(connection, query, args);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, e, () -> "Query: " + query + "\nData: " + Arrays.toString(args));
        }
    }

    public static void setParameters(@NotNull PreparedStatement preparedStatement, Object ... args) throws SQLException {
        for (int i = 0; args != null && i < args.length; ++i) {
            preparedStatement.setObject(i + 1, args[i]);
        }
    }

    public static void validateUUIDs(@NotNull Logger logger, @NotNull Connection connection, @NotNull String tableName, @NotNull String nameColumnName, @NotNull String uuidColumnName, @NotNull String idColumnName, boolean useUuidSeparators, boolean useOnlineUUIDs) throws SQLException {
        new UUIDValidator(logger, connection, tableName, nameColumnName, uuidColumnName, idColumnName, useUuidSeparators, useOnlineUUIDs).validateUUIDs();
    }
}

