/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.PooledConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class SQLiteConnectionProvider
extends PooledConnectionProvider {
    private final String databasePath;

    public SQLiteConnectionProvider(@NotNull Logger logger, @NotNull String pluginName, @NotNull String databasePath) {
        super(logger, pluginName);
        this.databasePath = databasePath;
        this.init();
    }

    @Override
    @NotNull
    protected HikariConfig getPoolConfig() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            this.logger.severe((Object)((Object)ConsoleColor.RED) + " Failed to load SQLite JDBC driver!" + (Object)((Object)ConsoleColor.RESET));
        }
        HikariConfig poolConfig = new HikariConfig();
        poolConfig.setMaximumPoolSize(1);
        poolConfig.setJdbcUrl("jdbc:sqlite:" + this.databasePath);
        poolConfig.setConnectionTestQuery("SELECT 1;");
        return poolConfig;
    }

    @Override
    public String getDatabaseType() {
        return "sqlite";
    }
}

