/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class PooledConnectionProvider
implements ConnectionProvider {
    protected final Logger logger;
    private final String pluginName;
    private HikariDataSource dataSource;

    protected PooledConnectionProvider(@NotNull Logger logger, @NotNull String pluginName) {
        this.logger = logger;
        this.pluginName = pluginName;
    }

    public void init() {
        try {
            HikariConfig poolConfig = this.getPoolConfig();
            poolConfig.setPoolName(this.pluginName + "-Connection-Pool");
            poolConfig.addDataSourceProperty("useUnicode", "true");
            poolConfig.addDataSourceProperty("characterEncoding", "utf-8");
            poolConfig.addDataSourceProperty("cachePrepStmts", "true");
            poolConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            poolConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            this.dataSource = new HikariDataSource(poolConfig);
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            this.logger.severe((Object)((Object)ConsoleColor.RED) + "There was a problem creating the connection pool for the SQL server! Please check your configuration." + (Object)((Object)ConsoleColor.RESET) + "\nError: " + cause.getMessage());
        }
    }

    @NotNull
    protected abstract HikariConfig getPoolConfig();

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.dataSource != null;
    }
}

