/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.PooledConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.DatabaseConnectionConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class MySQLConnectionProvider
extends PooledConnectionProvider {
    private final DatabaseConnectionConfiguration connectionConfiguration;

    public MySQLConnectionProvider(@NotNull Logger logger, @NotNull String pluginName, @NotNull DatabaseConnectionConfiguration connectionConfiguration) {
        super(logger, pluginName);
        this.connectionConfiguration = connectionConfiguration;
        this.init();
    }

    @Override
    @NotNull
    protected HikariConfig getPoolConfig() {
        try {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException ignored) {
                Class.forName("com.mysql.jdbc.Driver");
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.severe((Object)((Object)ConsoleColor.RED) + " Failed to load MySQL JDBC driver!" + (Object)((Object)ConsoleColor.RESET));
        }
        HikariConfig poolConfig = new HikariConfig();
        poolConfig.setJdbcUrl("jdbc:mysql://" + this.connectionConfiguration.getSQLHost() + "/" + this.connectionConfiguration.getSQLDatabase() + this.connectionConfiguration.getSQLConnectionProperties());
        poolConfig.setUsername(this.connectionConfiguration.getSQLUser());
        poolConfig.setPassword(this.connectionConfiguration.getSQLPassword());
        poolConfig.setMinimumIdle(1);
        poolConfig.setMaximumPoolSize(this.connectionConfiguration.getSQLMaxConnections());
        if (this.connectionConfiguration.getSQLMaxLifetime() > 0L) {
            poolConfig.setMaxLifetime(this.connectionConfiguration.getSQLMaxLifetime());
        }
        if (this.connectionConfiguration.getSQLIdleTimeout() > 0L) {
            poolConfig.setIdleTimeout(this.connectionConfiguration.getSQLIdleTimeout());
        }
        return poolConfig;
    }

    @Override
    public String getDatabaseType() {
        return "mysql";
    }
}

