/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.ILanguageConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.YamlFileManager;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.YamlFileUpdateMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YAML;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlGetter;
import java.io.File;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Language
extends YamlFileManager {
    protected static final String KEY_LANGUAGE = "Language.";
    protected static final String KEY_ADDITION_SEND_METHOD = "_SendMethod";
    protected static final String KEY_ADDITION_PARAMETERS = "_Parameters";
    protected static final String KEY_ADDITION_PAPI = "_PAPI";
    private static final String MESSAGE_NOT_FOUND = MessageColor.RED + "Message not found!";
    private final Object plugin;
    private final String prefix;
    protected String language = "en";
    protected String fallbackLanguage = "en";
    private boolean extractedFallback = false;
    private YamlFileUpdateMethod yamlUpdateMode;

    public Language(@NotNull IPlugin plugin, Version version) {
        this(plugin, version, File.separator + "lang", "");
    }

    public Language(@NotNull IPlugin plugin, Version version, @Nullable String path, @NotNull String prefix) {
        this(plugin, version, path, prefix, prefix);
    }

    public Language(@NotNull IPlugin plugin, Version version, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        this(plugin, plugin.getLogger(), plugin.getDataFolder(), version, path, prefix, inJarPrefix);
    }

    public Language(@NotNull Object plugin, @NotNull Logger logger, @NotNull File baseDir, Version version, @Nullable String path, @NotNull String prefix, @NotNull String inJarPrefix) {
        super(logger, baseDir, version, path, prefix, "/lang/" + inJarPrefix, null);
        this.prefix = prefix;
        this.setFileDescription("language");
        this.plugin = plugin;
    }

    @NotNull
    public String get(@NotNull String path) {
        String msg = this.yaml.getString(KEY_LANGUAGE + path, null);
        if (msg == null) {
            this.logger.warning("No translation for key: " + path);
            return MESSAGE_NOT_FOUND;
        }
        return msg;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public String getRaw(@NotNull String key, @Nullable String defaultValue) {
        return this.yaml.getString(key, defaultValue);
    }

    protected void set(@NotNull String path, @NotNull String value) {
        this.yaml.set(path, value);
    }

    public void reload() {
        this.load(this.language, this.yamlUpdateMode);
    }

    public boolean load(@NotNull ILanguageConfiguration config) {
        return this.load(config.getLanguage(), config.getLanguageUpdateMode());
    }

    public boolean load(@NotNull String language, @NotNull YamlFileUpdateMethod updateMode) {
        return this.load(language, updateMode, "en");
    }

    public boolean load(@NotNull String language, @NotNull YamlFileUpdateMethod updateMode, @NotNull String fallbackLanguage) {
        this.language = language.toLowerCase(Locale.ROOT);
        this.yamlUpdateMode = updateMode;
        this.fallbackLanguage = fallbackLanguage;
        this.extractedFallback = false;
        this.extracted = false;
        this.file = language + ".yml";
        this.yamlFile = new File(this.baseDir, this.prefix + this.file);
        this.load();
        return this.isLoaded();
    }

    @Override
    protected void extractFile() {
        if (this.extracted || !Utils.extractFile(this.jarClass(), this.logger, this.inJarPrefix + this.file, this.yamlFile)) {
            if (!this.language.equals(this.fallbackLanguage)) {
                Utils.extractFile(this.jarClass(), this.logger, this.inJarPrefix + this.fallbackLanguage + ".yml", this.yamlFile);
                this.extractedFallback = true;
            } else {
                this.logger.warning((Object)((Object)ConsoleColor.RED) + "Fallback language file failed to extract!" + (Object)((Object)ConsoleColor.RESET));
            }
        }
        this.extracted = true;
    }

    @Override
    @NotNull
    protected YamlFileUpdateMethod decideYamlUpdateMode() {
        if (this.extractedFallback) {
            return YamlFileUpdateMethod.UPDATE;
        }
        if (this.getYamlUpdateMode() != null) {
            return this.getYamlUpdateMode();
        }
        return YamlFileUpdateMethod.UPGRADE;
    }

    @Override
    protected void doUpgrade(@NotNull YamlFileManager oldYamlFile) {
        this.logger.info("No custom " + this.getFileDescription() + " upgrade code. Copying data from old file to new one.");
        for (String key : this.yaml.getKeys()) {
            if (!oldYamlFile.yaml.isSet(key) || key.equals("Version")) continue;
            if (oldYamlFile.yaml.isList(key)) {
                this.yaml.set(key, oldYamlFile.yaml.getStringList(key, new LinkedList<String>()));
                continue;
            }
            this.yaml.set(key, oldYamlFile.yaml.getString(key, null));
            if (oldYamlFile.yaml.isSet(key + KEY_ADDITION_SEND_METHOD)) {
                this.yaml.set(key + KEY_ADDITION_SEND_METHOD, oldYamlFile.yaml.getString(key + KEY_ADDITION_SEND_METHOD, null));
            }
            if (!oldYamlFile.yaml.isSet(key + KEY_ADDITION_PARAMETERS)) continue;
            this.yaml.set(key + KEY_ADDITION_PARAMETERS, oldYamlFile.yaml.getString(key + KEY_ADDITION_PARAMETERS, null));
        }
    }

    @Nullable
    public YAML getLang() {
        return this.getYaml();
    }

    @NotNull
    public YAML getLangE() throws LanguageNotInitializedException {
        if (this.yaml == null) {
            throw new LanguageNotInitializedException();
        }
        return this.yaml;
    }

    @NotNull
    public YamlGetter getLangReadOnly() throws LanguageNotInitializedException {
        return this.getLangE();
    }

    @NotNull
    public String getTranslated(@NotNull String path) {
        return MessageColor.translateAlternateColorAndFormatCodes(this.get(path));
    }

    @NotNull
    public String getLanguage() {
        return this.getLang().getString("LanguageName", this.language);
    }

    @NotNull
    public String getAuthor() {
        return this.getLang().getString("Author", "Unknown");
    }

    @Override
    protected void loaded() {
        String author = this.getAuthor().equals("Unknown") ? "" : "  Author: " + this.getAuthor();
        this.logger.info((Object)((Object)ConsoleColor.GREEN) + this.getFileDescriptionCapitalized() + " file successfully loaded. Language: " + this.getLanguage() + author + (Object)((Object)ConsoleColor.RESET));
    }

    @Override
    protected Class<?> jarClass() {
        return this.plugin.getClass();
    }

    @Override
    @Generated
    public YamlFileUpdateMethod getYamlUpdateMode() {
        return this.yamlUpdateMode;
    }

    public static class LanguageNotInitializedException
    extends RuntimeException {
        private LanguageNotInitializedException() {
            super("The language file has not been loaded successful");
        }
    }
}

