/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.HelpData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubCommand<COMMAND_SENDER> {
    private final String name;
    private final String description;
    private final String permission;
    private final List<String> aliases;

    protected SubCommand(@NotNull String name, @NotNull String description, @Nullable String permission, String ... aliases) {
        this.name = name.toLowerCase(Locale.ROOT);
        if (aliases != null) {
            this.aliases = new ArrayList<String>(aliases.length + 1);
            for (String alias : aliases) {
                if (alias == null) continue;
                this.aliases.add(alias.toLowerCase(Locale.ROOT));
            }
        } else {
            this.aliases = new ArrayList<String>(1);
        }
        if (!this.aliases.contains(this.name)) {
            this.aliases.add(this.name);
        }
        this.description = description;
        this.permission = permission;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getTranslatedName() {
        return this.aliases.get(0);
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void close() {
    }

    @Deprecated
    public void registerSubCommands() {
    }

    @Deprecated
    public void unRegisterSubCommands() {
    }

    public void beforeRegister() {
    }

    public void afterRegister() {
    }

    public void beforeUnregister() {
    }

    public void afterUnRegister() {
    }

    public abstract boolean canUse(@NotNull COMMAND_SENDER var1);

    @Nullable
    public List<HelpData> doGetHelp(@NotNull COMMAND_SENDER requester) {
        return this.canUse(requester) ? this.getHelp(requester) : null;
    }

    public abstract void showHelp(@NotNull COMMAND_SENDER var1, @NotNull String var2);

    @Nullable
    public abstract List<HelpData> getHelp(@NotNull COMMAND_SENDER var1);

    public abstract void doExecute(@NotNull COMMAND_SENDER var1, @NotNull String var2, @NotNull String var3, @NotNull String[] var4);

    public abstract void execute(@NotNull COMMAND_SENDER var1, @NotNull String var2, @NotNull String var3, @NotNull String[] var4);

    public abstract List<String> doTabComplete(@NotNull COMMAND_SENDER var1, @NotNull String var2, @NotNull String var3, @NotNull String[] var4);

    public abstract List<String> tabComplete(@NotNull COMMAND_SENDER var1, @NotNull String var2, @NotNull String var3, @NotNull String[] var4);
}

