/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Command.SubCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CommandExecutorWithSubCommands<SUB_COMMAND extends SubCommand> {
    protected Map<String, SUB_COMMAND> subCommandMap = new HashMap<String, SUB_COMMAND>();
    protected Collection<SUB_COMMAND> commands = new ArrayList<SUB_COMMAND>();
    protected SUB_COMMAND defaultSubCommand = null;

    public void close() {
        for (SubCommand command : this.commands) {
            command.close();
        }
        this.commands.clear();
        this.subCommandMap.clear();
    }

    public void setDefaultSubCommand(SUB_COMMAND command) {
        this.defaultSubCommand = command;
    }

    public void registerSubCommand(@NotNull SUB_COMMAND command) {
        ((SubCommand)command).beforeRegister();
        this.commands.add(command);
        @NotNull List<String> aliases = ((SubCommand)command).getAliases();
        for (String alias : aliases) {
            this.subCommandMap.put(alias, command);
        }
        ((SubCommand)command).registerSubCommands();
        ((SubCommand)command).afterRegister();
    }

    public void unRegisterSubCommand(@NotNull SUB_COMMAND command) {
        ((SubCommand)command).beforeUnregister();
        ((SubCommand)command).unRegisterSubCommands();
        this.commands.remove(command);
        @NotNull List<String> aliases = ((SubCommand)command).getAliases();
        for (String alias : aliases) {
            this.subCommandMap.remove(alias);
        }
        ((SubCommand)command).afterUnRegister();
    }
}

