/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.BasicTimeSpanFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.TimeSpanFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeSpan {
    public static final byte YEAR = 0;
    public static final byte MONTH = 1;
    public static final byte DAY = 2;
    public static final byte HOUR = 3;
    public static final byte MINUTE = 4;
    public static final byte SECOND = 5;
    public static final byte TOTAL_DAYS = 6;
    private static final BasicTimeSpanFormat DEFAULT_TIME_SPAN_FORMAT = new BasicTimeSpanFormat();
    private static final int[] CAL_TYPES = new int[]{1, 2, 5};
    private int[] timeSpan = new int[]{0, 0, 0, 0, 0, 0, 0};

    public TimeSpan(long time) {
        this(time, false);
    }

    public TimeSpan(long time, boolean fastMode) {
        this(time, System.currentTimeMillis(), fastMode);
    }

    public TimeSpan(long timeFrom, long timeTo) {
        this(timeFrom, timeTo, false);
    }

    public TimeSpan(long timeFrom, long timeTo, boolean fastMode) {
        this(timeFrom, null, timeTo, null, fastMode);
    }

    public TimeSpan(@NotNull Date time) {
        this(time, false);
    }

    public TimeSpan(@NotNull Date time, boolean fastMode) {
        this(time, new Date(), fastMode);
    }

    public TimeSpan(@NotNull Date timeFrom, @NotNull Date timeTo) {
        this(timeFrom, timeTo, false);
    }

    public TimeSpan(@NotNull Date timeFrom, @NotNull Date timeTo, boolean fastMode) {
        this(timeFrom.getTime(), null, timeTo.getTime(), null, fastMode);
    }

    public TimeSpan(@NotNull Calendar time) {
        this(time, false);
    }

    public TimeSpan(@NotNull Calendar time, boolean fastMode) {
        this(time, Calendar.getInstance(), fastMode);
    }

    public TimeSpan(@NotNull Calendar timeFrom, @NotNull Calendar timeTo) {
        this(timeFrom, timeTo, false);
    }

    public TimeSpan(@NotNull Calendar timeFrom, @NotNull Calendar timeTo, boolean fastMode) {
        this(timeFrom.getTimeInMillis(), timeFrom, timeTo.getTimeInMillis(), timeTo, fastMode);
    }

    private TimeSpan(long from, @Nullable Calendar fromDate, long to, @Nullable Calendar toDate, boolean fastMode) {
        long totalDiffSeconds = this.totalDiffSeconds(from, to);
        if (fastMode) {
            this.calcFast(totalDiffSeconds);
        } else {
            if (fromDate == null) {
                fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(from);
            }
            if (toDate == null) {
                toDate = Calendar.getInstance();
                toDate.setTimeInMillis(to);
            }
            if (toDate.before(fromDate)) {
                Calendar tmpDate = fromDate;
                fromDate = toDate;
                toDate = tmpDate;
            }
            this.calcCalendar(totalDiffSeconds, fromDate, toDate);
        }
    }

    private long totalDiffSeconds(long from, long to) {
        return (to > from ? to - from : from - to) / 1000L;
    }

    private void calcFast(long totalDiffSeconds) {
        this.timeSpan[6] = (int)(totalDiffSeconds / 86400L);
        this.timeSpanDaysFast();
        this.timeSpanDayComponents(totalDiffSeconds);
    }

    private void calcCalendar(long totalDiffSeconds, @NotNull Calendar fromDate, @NotNull Calendar toDate) {
        this.timeSpan[6] = (int)(totalDiffSeconds / 86400L);
        this.timeSpanDaysCalendar(fromDate, toDate);
        this.timeSpanDayComponents(totalDiffSeconds);
    }

    private void timeSpanDayComponents(long totalDiffSeconds) {
        int secondsOnDay = (int)(totalDiffSeconds % 86400L);
        this.timeSpan[3] = secondsOnDay / 3600;
        this.timeSpan[4] = (secondsOnDay -= this.timeSpan[3] * 3600) / 60;
        this.timeSpan[5] = secondsOnDay % 60;
    }

    private void timeSpanDaysFast() {
        this.timeSpan[0] = this.timeSpan[6] / 365;
        this.timeSpan[2] = this.timeSpan[6] - this.timeSpan[0] * 365;
        this.timeSpan[1] = (int)((double)this.timeSpan[2] / 30.416666666666668);
        this.timeSpan[2] = (int)((double)this.timeSpan[2] - (double)this.timeSpan[1] * 30.416666666666668);
    }

    private void timeSpanDaysCalendar(@NotNull Calendar fromDate, @NotNull Calendar toDate) {
        this.timeSpan[2] = -1;
        this.timeSpan[1] = -1;
        this.timeSpan[0] = -1;
        Calendar from = (Calendar)fromDate.clone();
        Calendar backup = (Calendar)from.clone();
        int dayOfMonth = from.get(5);
        for (int i = 0; i < CAL_TYPES.length; ++i) {
            while (!from.after(toDate)) {
                backup = (Calendar)from.clone();
                from.add(CAL_TYPES[i], 1);
                if (CAL_TYPES[i] != 5 && from.get(5) < dayOfMonth && from.get(5) < from.getActualMaximum(5)) {
                    from.set(5, Math.min(from.getActualMaximum(5), dayOfMonth));
                }
                int n = i;
                this.timeSpan[n] = this.timeSpan[n] + 1;
            }
            from = backup;
        }
    }

    private TimeSpan() {
    }

    @NotNull
    public static TimeSpan fromMilliseconds(long ms) {
        return TimeSpan.fromSeconds(ms / 1000L);
    }

    @NotNull
    public static TimeSpan fromSeconds(long seconds) {
        TimeSpan timeSpan = new TimeSpan();
        timeSpan.calcFast(seconds);
        return timeSpan;
    }

    public String toString() {
        return this.toString(DEFAULT_TIME_SPAN_FORMAT);
    }

    @Deprecated
    public String toString(@NotNull String[] unitNames) {
        return this.toString(new BasicTimeSpanFormat(unitNames));
    }

    public String toString(TimeSpanFormat timeSpanFormat) {
        return timeSpanFormat.format(this);
    }

    public int getYears() {
        return this.timeSpan[0];
    }

    public int getMonths() {
        return this.timeSpan[1];
    }

    public int getDays() {
        return this.timeSpan[2];
    }

    public int getTotalDays() {
        return this.timeSpan[6];
    }

    public int getHours() {
        return this.timeSpan[3];
    }

    public int getMinutes() {
        return this.timeSpan[4];
    }

    public int getSeconds() {
        return this.timeSpan[5];
    }

    @NotNull
    public int[] getArray() {
        return (int[])this.timeSpan.clone();
    }

    @NotNull
    public int[] getArrayNoCopy() {
        return this.timeSpan;
    }

    public boolean equals(Object obj) {
        return obj instanceof TimeSpan && Arrays.equals(((TimeSpan)obj).timeSpan, this.timeSpan);
    }

    public int hashCode() {
        return Arrays.hashCode(this.timeSpan);
    }
}

