/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.TimeSpan;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.TimeSpanFormat;
import org.jetbrains.annotations.NotNull;

public class BasicTimeSpanFormat
implements TimeSpanFormat {
    private final String[] unitNames;

    public BasicTimeSpanFormat() {
        this(new String[]{"year", "years", "month", "months", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds"});
    }

    public BasicTimeSpanFormat(@NotNull String[] timeUnitNames) {
        if (timeUnitNames.length != 12) {
            throw new IllegalArgumentException("Wrong amount of unit names given. Please make sure that the array is in the right format.\nLike: new String[] { \"year\", \"years\", \"month\", \"months\", \"day\", \"days\", \"hour\", \"hours\", \"minute\", \"minutes\", \"second\", \"seconds\" }");
        }
        this.unitNames = (String[])timeUnitNames.clone();
    }

    @Override
    public String format(TimeSpan span) {
        int[] timeSpan = span.getArrayNoCopy();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if (timeSpan[i] <= 0 && (i != 5 || stringBuilder.length() != 0)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(timeSpan[i]);
            stringBuilder.append(' ');
            stringBuilder.append(timeSpan[i] == 1 ? this.unitNames[i * 2] : this.unitNames[i * 2 + 1]);
        }
        return stringBuilder.toString();
    }
}

