/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.ISender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.TitleMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import java.util.Collection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Title;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TitleSender
implements ISender {
    private static final TitleMetadata METADATA = new TitleMetadata();
    private static final Title EMPTY_TITLE = TitleSender.mkTitlePacket("", METADATA);

    TitleSender() {
    }

    private static Title mkTimesPacket(@NotNull TitleMetadata metadata) {
        Title titleTimes = new Title();
        titleTimes.setAction(Title.Action.TIMES);
        titleTimes.setFadeIn(metadata.getFadeIn());
        titleTimes.setStay(metadata.getStay());
        titleTimes.setFadeOut(metadata.getFadeOut());
        return titleTimes;
    }

    private static Title mkTitlePacket(@NotNull String json, @NotNull TitleMetadata metadata) {
        Title titleSend = new Title();
        titleSend.setAction(metadata.getTitleType());
        titleSend.setText(json);
        return titleSend;
    }

    @Override
    public void send(@NotNull ProxiedPlayer player, @NotNull String json) {
        this.send(player, json, (IMetadata)METADATA);
    }

    @Override
    public void send(@NotNull ProxiedPlayer player, @NotNull String json, @Nullable IMetadata optional) {
        TitleMetadata metadata;
        TitleMetadata titleMetadata = metadata = optional instanceof TitleMetadata ? (TitleMetadata)optional : METADATA;
        if (metadata.isActionBar()) {
            player.unsafe().sendPacket((DefinedPacket)TitleSender.mkTitlePacket(json, metadata));
        } else {
            player.unsafe().sendPacket((DefinedPacket)TitleSender.mkTitlePacket(json, metadata));
            if (metadata.isSubtitle()) {
                player.unsafe().sendPacket((DefinedPacket)EMPTY_TITLE);
            }
        }
    }

    @Override
    public void send(@NotNull Collection<? extends ProxiedPlayer> players, @NotNull String json) {
        this.send(players, json, (IMetadata)METADATA);
    }

    @Override
    public void send(@NotNull Collection<? extends ProxiedPlayer> players, @NotNull String json, @Nullable IMetadata optional) {
        TitleMetadata metadata = optional instanceof TitleMetadata ? (TitleMetadata)optional : METADATA;
        Title titleTimes = TitleSender.mkTimesPacket(metadata);
        Title titleSend = TitleSender.mkTitlePacket(json, metadata);
        Title title = metadata.isSubtitle() ? EMPTY_TITLE : null;
        for (ProxiedPlayer proxiedPlayer : players) {
            proxiedPlayer.unsafe().sendPacket((DefinedPacket)titleTimes);
            proxiedPlayer.unsafe().sendPacket((DefinedPacket)titleSend);
            if (title == null) continue;
            proxiedPlayer.unsafe().sendPacket((DefinedPacket)title);
        }
    }

    @Override
    public void broadcast(@NotNull String json) {
        this.broadcast(json, METADATA);
    }
}

