/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.ISender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Chat;
import org.jetbrains.annotations.NotNull;

final class ChatSender
implements ISender {
    private static final Constructor<? extends DefinedPacket> SYSTEM_CHAT_CONSTRUCTOR;
    private static final byte CHAT_ACTION = 0;

    ChatSender() {
    }

    @Override
    public void send(@NotNull ProxiedPlayer player, @NotNull String json) {
        if (player.getPendingConnection().getVersion() >= 759) {
            player.unsafe().sendPacket(ChatSender.createSystemChatPacket(json));
        } else {
            player.unsafe().sendPacket((DefinedPacket)new Chat(json, 0));
        }
    }

    @Override
    public void send(@NotNull Collection<? extends ProxiedPlayer> players, @NotNull String json) {
        Chat legacyChatPacket = new Chat(json, 0);
        DefinedPacket newChatPacket = null;
        for (ProxiedPlayer proxiedPlayer : players) {
            if (proxiedPlayer.getPendingConnection().getVersion() >= 759) {
                if (newChatPacket == null) {
                    newChatPacket = ChatSender.createSystemChatPacket(json);
                }
                proxiedPlayer.unsafe().sendPacket(newChatPacket);
                continue;
            }
            proxiedPlayer.unsafe().sendPacket((DefinedPacket)legacyChatPacket);
        }
    }

    private static DefinedPacket createSystemChatPacket(@NotNull String json) {
        try {
            return SYSTEM_CHAT_CONSTRUCTOR.newInstance(json, 1);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Class<?> systemChatClass = Reflection.getClassSilent("net.md_5.bungee.protocol.packet.SystemChat");
        SYSTEM_CHAT_CONSTRUCTOR = systemChatClass != null ? Reflection.getConstructor(systemChatClass, String.class, Integer.TYPE) : null;
    }
}

