/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message;

import at.pcgamingfreaks.Bungee.Message.IMessage;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.MessageBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.BossBarMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.SendMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Sender.TitleMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Message
extends at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message<Message, ProxiedPlayer, CommandSender>
implements IMessage {
    @NotNull
    private SendMethod sendMethod = SendMethod.CHAT;

    public Message(@NotNull String message) {
        super(message);
    }

    public Message(@NotNull String message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull MessageComponent[] message) {
        this(Arrays.asList(message));
    }

    public Message(@NotNull MessageComponent[] message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull Collection<? extends MessageComponent> message) {
        super(message);
    }

    public Message(@NotNull Collection<MessageComponent> message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull MessageBuilder messageBuilder) {
        this(messageBuilder.getJsonMessageAsList());
    }

    public Message(@NotNull MessageBuilder messageBuilder, @NotNull SendMethod method) {
        this(messageBuilder.getJsonMessageAsList(), method);
    }

    public void setSendMethod(@Nullable SendMethod method) {
        this.sendMethod = method == null ? SendMethod.DISABLED : method;
    }

    @Override
    public void setOptionalParameters(@NotNull IMetadata optionalParameters) {
        if (!(optionalParameters instanceof TitleMetadata) && !(optionalParameters instanceof BossBarMetadata)) {
            throw new IllegalArgumentException("The metadata object needs to be an instance of TitleMetadata or BossBarMetadata");
        }
        super.setOptionalParameters(optionalParameters);
    }

    public void send(@NotNull CommandSender target, Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        if (target instanceof ProxiedPlayer) {
            this.sendMethod.getSender().send((ProxiedPlayer)target, this.prepareMessage(true, args), this.optionalParameters);
        } else {
            target.sendMessage(this.prepareMessage(false, args));
        }
    }

    public void send(@NotNull Collection<? extends ProxiedPlayer> targets, Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED || targets.isEmpty()) {
            return;
        }
        this.sendMethod.getSender().send(targets, this.prepareMessage(true, args), this.optionalParameters);
    }

    public void broadcast(Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        ProxyServer.getInstance().getConsole().sendMessage(this.prepareMessage(false, args));
        this.sendMethod.getSender().broadcast(this.prepareMessage(true, args), this.optionalParameters);
    }

    @NotNull
    @Generated
    public SendMethod getSendMethod() {
        return this.sendMethod;
    }

    static {
        Constructor builderConstructor = null;
        try {
            builderConstructor = MessageBuilder.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Message.setMessageComponentClass(builderConstructor);
    }
}

