/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Database.Cache.UnCacheStrategies;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.BaseUnCacheStrategy;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.ICacheablePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.IPlayerCache;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

public class OnDisconnectDelayed
extends BaseUnCacheStrategy
implements Listener {
    private final Plugin plugin;
    private final long delay;

    public OnDisconnectDelayed(@NotNull Plugin plugin, @NotNull IPlayerCache cache, long delay) {
        super(cache);
        this.plugin = plugin;
        this.delay = delay;
        plugin.getProxy().getPluginManager().registerListener(plugin, (Listener)this);
    }

    @EventHandler(priority=127)
    public void playerLeaveEvent(PlayerDisconnectEvent event) {
        ICacheablePlayer player = this.cache.getCachedPlayer(event.getPlayer().getUniqueId());
        if (player != null && player.canBeUncached()) {
            this.plugin.getProxy().getScheduler().schedule(this.plugin, () -> {
                if (!player.isOnline()) {
                    this.cache.unCache(player);
                }
            }, this.delay, TimeUnit.SECONDS);
        }
    }

    @Override
    public void close() {
        this.plugin.getProxy().getPluginManager().unregisterListener((Listener)this);
    }
}

