/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.IUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils
extends at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils {
    private static final IUtils INSTANCE = IUtils.INSTANCE;
    private static final Method METHOD_JAVA_PLUGIN_GET_FILE = Reflection.getMethod(JavaPlugin.class, "getFile", new Class[0]);
    public static final ChatColor[] CHAT_COLORS = new ChatColor[16];

    private Utils() {
    }

    public static boolean isPerWorldPluginsInstalled() {
        return Bukkit.getServer().getPluginManager().getPlugin("PerWorldPlugins") != null;
    }

    public static void warnIfPerWorldPluginsIsInstalled(@NotNull Logger logger) {
        Utils.warnIfPerWorldPluginsIsInstalled(logger, 5);
    }

    public static void warnIfPerWorldPluginsIsInstalled(@NotNull Logger logger, int pauseTime) {
        if (Utils.isPerWorldPluginsInstalled()) {
            logger.warning((Object)((Object)ConsoleColor.RED) + "   !!!!!!!!!!!!!!!!!!!!!!!!!" + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.RED) + "   !!!!!! - WARNING - !!!!!!" + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.RED) + "   !!!!!!!!!!!!!!!!!!!!!!!!!" + (Object)((Object)ConsoleColor.RESET) + "\n");
            logger.warning((Object)((Object)ConsoleColor.RED) + " We have detected that you are using \"PerWorldPlugins\"!" + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.YELLOW) + " Please allow this plugin to run in " + (Object)((Object)ConsoleColor.BLUE) + " ALL " + (Object)((Object)ConsoleColor.YELLOW) + " worlds." + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.YELLOW) + " If you block it from running in all worlds there probably will be problems!" + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.YELLOW) + " If you don't want you players to use this plugin in certain worlds please use permissions and the plugins config!" + (Object)((Object)ConsoleColor.RESET));
            logger.warning((Object)((Object)ConsoleColor.RED) + " There will be no support for bugs caused by \"PerWorldPlugins\"!" + (Object)((Object)ConsoleColor.RESET));
            Utils.blockThread(pauseTime);
        }
    }

    public static File getPluginJarFile(@NotNull JavaPlugin plugin) throws RuntimeException {
        try {
            return (File)METHOD_JAVA_PLUGIN_GET_FILE.invoke((Object)plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve jar file for plugin " + plugin.getName(), e);
        }
    }

    @NotNull
    public static List<String> getPlayerNamesStartingWith(@NotNull String startingWith, @Nullable CommandSender forUser) {
        return Utils.getPlayerNamesStartingWithVisibleOnly(startingWith, forUser, "*");
    }

    @NotNull
    public static List<String> getPlayerNamesStartingWithVisibleOnly(@NotNull String startingWith, @Nullable CommandSender forUser, @NotNull String vanishBypassPermission) {
        String excludeName = forUser instanceof Player ? forUser.getName().toLowerCase(Locale.ROOT) : null;
        startingWith = startingWith.toLowerCase(Locale.ROOT);
        ArrayList<String> names = new ArrayList<String>(Bukkit.getOnlinePlayers().size());
        boolean excludeVanished = forUser instanceof Player && !"*".equals(vanishBypassPermission) && !forUser.hasPermission(vanishBypassPermission);
        for (Player player : Bukkit.getOnlinePlayers()) {
            String nameLower;
            if (excludeVanished && !((Player)forUser).canSee(player) || (nameLower = player.getName().toLowerCase(Locale.ROOT)).equals(excludeName) || !nameLower.startsWith(startingWith)) continue;
            names.add(player.getName());
        }
        return names;
    }

    public static int getPing(@NotNull Player player) {
        return INSTANCE.getPing(player);
    }

    public static void sendPacket(@NotNull Player player, @NotNull Object packet) {
        INSTANCE.sendPacket(player, packet);
    }

    public static double getDistance(@NotNull Player player1, @NotNull Player player2) {
        if (player1.equals(player2)) {
            return 0.0;
        }
        if (player1.getWorld().getName().equalsIgnoreCase(player2.getWorld().getName())) {
            return player1.getLocation().distance(player2.getLocation());
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double getDistanceSquared(@NotNull Player player1, @NotNull Player player2) {
        if (player1.equals(player2)) {
            return 0.0;
        }
        if (player1.getWorld().getName().equalsIgnoreCase(player2.getWorld().getName())) {
            return player1.getLocation().distanceSquared(player2.getLocation());
        }
        return Double.POSITIVE_INFINITY;
    }

    public static boolean inRange(@NotNull Player player1, @NotNull Player player2, double maxDistance) {
        if (maxDistance < 0.0) {
            return true;
        }
        double distance = Utils.getDistanceSquared(player1, player2);
        return maxDistance == 0.0 && distance != Double.POSITIVE_INFINITY || distance <= maxDistance * maxDistance;
    }

    public static boolean inRangeSquared(@NotNull Player player1, @NotNull Player player2, double maxDistanceSquared) {
        if (maxDistanceSquared < 0.0) {
            return true;
        }
        double distance = Utils.getDistanceSquared(player1, player2);
        return maxDistanceSquared == 0.0 && distance != Double.POSITIVE_INFINITY || distance <= maxDistanceSquared;
    }

    public static boolean inRange(@NotNull Player player1, @NotNull Player player2, double maxDistance, @NotNull String bypassPermission) {
        return player1.hasPermission(bypassPermission) || player2.hasPermission(bypassPermission) || Utils.inRange(player1, player2, maxDistance);
    }

    public static boolean inRangeSquared(@NotNull Player player1, @NotNull Player player2, double maxDistanceSquared, @NotNull String bypassPermission) {
        return player1.hasPermission(bypassPermission) || player2.hasPermission(bypassPermission) || Utils.inRangeSquared(player1, player2, maxDistanceSquared);
    }

    @Nullable
    public static Object jsonToIChatComponent(@NotNull String json) {
        return INSTANCE.jsonToIChatComponent(json);
    }

    public static boolean detectBungeeCord() {
        try {
            Object spigotServer = Server.class.getMethod("spigot", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            Method getConfigMethod = spigotServer.getClass().getMethod("getConfig", new Class[0]);
            getConfigMethod.setAccessible(true);
            YamlConfiguration spigotConfig = (YamlConfiguration)getConfigMethod.invoke(spigotServer, new Object[0]);
            return spigotConfig.getBoolean("settings.bungeecord");
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        int i = 0;
        for (ChatColor c : ChatColor.values()) {
            if (!c.isColor() || c == ChatColor.RESET) continue;
            Utils.CHAT_COLORS[i++] = c;
        }
    }
}

