/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.PlatformResolver;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.IInventoryUtils;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    private static final IInventoryUtils INSTANCE = PlatformResolver.createPlatformInstance(IInventoryUtils.class);

    public static String convertItemStackToJson(@NotNull ItemStack itemStack, @NotNull Logger logger) {
        return INSTANCE.convertItemStackToJson(itemStack, logger);
    }

    public static void dropInventory(@NotNull Inventory inventory, @NotNull Location location) {
        InventoryUtils.dropInventory(inventory, location, true);
    }

    public static void dropInventory(@NotNull Inventory inventory, @NotNull Location location, boolean clearInventory) {
        for (ItemStack i : inventory.getContents()) {
            if (i == null) continue;
            location.getWorld().dropItemNaturally(location, i);
        }
        if (clearInventory) {
            inventory.clear();
        }
    }

    @Nullable
    public static Inventory getClickedInventory(@NotNull InventoryClickEvent event) {
        if (event.getRawSlot() < 0) {
            return null;
        }
        return event.getRawSlot() < event.getView().getTopInventory().getSize() ? event.getView().getTopInventory() : event.getView().getBottomInventory();
    }

    @Nullable
    public static ItemStack getItemInHand(@NotNull Player player) {
        if (MCVersion.isDualWieldingMC()) {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.getType() != Material.AIR) {
                return item;
            }
            return player.getInventory().getItemInOffHand();
        }
        return player.getItemInHand();
    }

    @Nullable
    public static ItemStack getItemInMainHand(@NotNull Player player) {
        if (MCVersion.isDualWieldingMC()) {
            return player.getInventory().getItemInMainHand();
        }
        return player.getItemInHand();
    }

    @Nullable
    public static ItemStack getItemInOffHand(@NotNull Player player) {
        if (MCVersion.isDualWieldingMC()) {
            return player.getInventory().getItemInOffHand();
        }
        return player.getItemInHand();
    }

    public static void setItemInMainHand(@NotNull Player player, @Nullable ItemStack item) {
        if (MCVersion.isDualWieldingMC()) {
            player.getInventory().setItemInMainHand(item);
        } else {
            player.setItemInHand(item);
        }
    }

    public static void setItemInOffHand(@NotNull Player player, @Nullable ItemStack item) {
        if (MCVersion.isDualWieldingMC()) {
            player.getInventory().setItemInOffHand(item);
        } else {
            player.setItemInHand(item);
        }
    }

    public static void updateInventoryTitle(@NotNull Player player, @NotNull String newTitle) {
        INSTANCE.updateInventoryTitle(player, newTitle);
    }

    public static void openInventoryWithCustomTitle(@NotNull Player player, @NotNull Inventory inventory, @NotNull String title) {
        INSTANCE.openInventoryWithCustomTitle(player, inventory, title);
    }

    public static void openInventoryWithCustomTitle(@NotNull Player player, @NotNull Inventory inventory, @NotNull Message title, Object ... args) {
        INSTANCE.openInventoryWithCustomTitlePrepared(player, inventory, InventoryUtils.prepareTitleForOpenInventoryWithCustomTitle(title, args));
    }

    public static void openInventoryWithCustomTitlePrepared(@NotNull Player player, @NotNull Inventory inventory, @NotNull Object title) {
        INSTANCE.openInventoryWithCustomTitlePrepared(player, inventory, title);
    }

    public static Object prepareTitleForOpenInventoryWithCustomTitle(@NotNull String title) {
        return INSTANCE.prepareTitleForOpenInventoryWithCustomTitle(title);
    }

    public static Object prepareTitleForOpenInventoryWithCustomTitle(@NotNull Message title, Object ... args) {
        if (MCVersion.isNewerOrEqualThan(MCVersion.MC_1_16)) {
            return title.prepareChatComponent(args);
        }
        return InventoryUtils.prepareTitleForOpenInventoryWithCustomTitle(title.prepareChatLegacy(args));
    }

    public static void setInventoryTitle(@NotNull Inventory inventory, @NotNull String newTitle) {
        INSTANCE.setInventoryTitle(inventory, newTitle);
    }

    private InventoryUtils() {
    }
}

