/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadUtils {
    public static final Material HEAD_MATERIAL = MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? Material.valueOf((String)"PLAYER_HEAD") : Material.valueOf((String)"SKULL_ITEM");

    public static ItemStack createHeadItemStack() {
        return HeadUtils.createHeadItemStack(1);
    }

    public static ItemStack createHeadItemStack(int amount) {
        return MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? new ItemStack(HEAD_MATERIAL, amount) : new ItemStack(HEAD_MATERIAL, amount, 3);
    }

    public static ItemStack fromUrl(@NotNull String url, @Nullable String itemName, @Nullable UUID ownerUUID) {
        return HeadUtils.fromBase64(HeadUtils.encodeUrl(url), itemName, ownerUUID);
    }

    public static ItemStack fromUrl(@NotNull String url, @Nullable String itemName, @Nullable UUID ownerUUID, int amount) {
        return HeadUtils.fromBase64(HeadUtils.encodeUrl(url), itemName, ownerUUID, amount);
    }

    public static ItemStack fromUrl(@NotNull ItemStack item, @NotNull String url, @Nullable String itemName, @Nullable UUID ownerUUID) {
        return HeadUtils.fromBase64(item, HeadUtils.encodeUrl(url), itemName, ownerUUID);
    }

    public static ItemStack fromBase64(@NotNull String value, @Nullable String itemName, @Nullable UUID ownerUUID) {
        return HeadUtils.fromBase64(HeadUtils.createHeadItemStack(), value, itemName, ownerUUID);
    }

    public static ItemStack fromBase64(@NotNull String value, @Nullable String itemName, @Nullable UUID ownerUUID, int amount) {
        return HeadUtils.fromBase64(HeadUtils.createHeadItemStack(amount), value, itemName, ownerUUID);
    }

    public static ItemStack fromBase64(@NotNull ItemStack item, @NotNull String value, @Nullable String itemName, @Nullable UUID ownerUUID) {
        if (ownerUUID == null) {
            ownerUUID = UUID.randomUUID();
        }
        StringBuilder builder = new StringBuilder("{");
        if (itemName != null) {
            builder.append("display:{Name:\"");
            if (MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13)) {
                builder.append("{\\\"text\\\":\\\"").append(itemName).append("\\\"}");
            } else {
                builder.append(itemName);
            }
            builder.append("\"},");
        }
        builder.append("SkullOwner:{Id:");
        if (MCVersion.isOlderThan(MCVersion.MC_1_16)) {
            builder.append('\"').append(ownerUUID.toString()).append('\"');
        } else {
            long most = ownerUUID.getMostSignificantBits();
            long least = ownerUUID.getLeastSignificantBits();
            builder.append("[I;");
            builder.append((int)(most >> 32)).append(',').append((int)most).append(',');
            builder.append((int)(least >> 32)).append(',').append((int)least).append(']');
        }
        builder.append(",Properties:{textures:[{Value:\"").append(value).append("\"}]}}}");
        Bukkit.getUnsafe().modifyItemStack(item, builder.toString());
        return item;
    }

    private static String encodeUrl(String url) {
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private HeadUtils() {
    }
}

