/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Protocol;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.NmsReflector;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Protocol.IChatMessagePacketFactory;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.IUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ChatMessagePacketFactory_Reflection
implements IChatMessagePacketFactory {
    private static final byte CHAT_TYPE = 0;
    private static final byte SYSTEM_TYPE = 1;
    private static final byte ACTION_BAR_TYPE = 2;
    private static final Class<?> I_CHAT_BASE_COMPONENT = NmsReflector.INSTANCE.getNmsClass("IChatBaseComponent");
    private static final Class<?> PACKET_PLAY_OUT_CHAT = NmsReflector.INSTANCE.getNmsClass("PacketPlayOutChat");
    private static final Constructor<?> PACKET_PLAY_OUT_CHAT_CONSTRUCTOR;
    private static final Method BYTE_TO_MESSAGE_TYPE_ENUM;
    private static final Object[] BYTE_TO_MESSAGE_MAP;

    @Override
    public Object makeChatPacket(@NotNull String json, @NotNull UUID sender) {
        return ChatMessagePacketFactory_Reflection.mkPacket(json, sender, (byte)0);
    }

    @Override
    public Object makeChatPacketSystem(@NotNull String json) {
        return ChatMessagePacketFactory_Reflection.mkPacket(json, EMPTY_UUID, (byte)1);
    }

    @Override
    public Object makeChatPacketActionBar(@NotNull String json) {
        return ChatMessagePacketFactory_Reflection.mkPacket(json, EMPTY_UUID, (byte)2);
    }

    private static Object mkPacket(@NotNull String json, @NotNull UUID sender, byte type) {
        try {
            Object chatComponent = IUtils.INSTANCE.jsonToIChatComponent(json);
            if (MCVersion.isOlderThan(MCVersion.MC_1_16)) {
                return PACKET_PLAY_OUT_CHAT_CONSTRUCTOR.newInstance(chatComponent, MCVersion.isOlderThan(MCVersion.MC_1_12) ? Byte.valueOf(type) : BYTE_TO_MESSAGE_MAP[type]);
            }
            return PACKET_PLAY_OUT_CHAT_CONSTRUCTOR.newInstance(chatComponent, BYTE_TO_MESSAGE_MAP[type], sender);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        if (MCVersion.isOlderThan(MCVersion.MC_1_12)) {
            PACKET_PLAY_OUT_CHAT_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_CHAT, I_CHAT_BASE_COMPONENT, Byte.TYPE);
            BYTE_TO_MESSAGE_TYPE_ENUM = null;
            BYTE_TO_MESSAGE_MAP = null;
        } else {
            Class<?> chatMessageType = NmsReflector.INSTANCE.getNmsClass("ChatMessageType");
            BYTE_TO_MESSAGE_TYPE_ENUM = NmsReflector.INSTANCE.getNmsMethod(chatMessageType, "a", Byte.TYPE);
            PACKET_PLAY_OUT_CHAT_CONSTRUCTOR = MCVersion.isOlderThan(MCVersion.MC_1_16) ? Reflection.getConstructor(PACKET_PLAY_OUT_CHAT, I_CHAT_BASE_COMPONENT, chatMessageType) : Reflection.getConstructor(PACKET_PLAY_OUT_CHAT, I_CHAT_BASE_COMPONENT, chatMessageType, UUID.class);
            BYTE_TO_MESSAGE_MAP = new Object[3];
            try {
                ChatMessagePacketFactory_Reflection.BYTE_TO_MESSAGE_MAP[0] = BYTE_TO_MESSAGE_TYPE_ENUM.invoke(null, (byte)0);
                ChatMessagePacketFactory_Reflection.BYTE_TO_MESSAGE_MAP[1] = BYTE_TO_MESSAGE_TYPE_ENUM.invoke(null, (byte)1);
                ChatMessagePacketFactory_Reflection.BYTE_TO_MESSAGE_MAP[2] = BYTE_TO_MESSAGE_TYPE_ENUM.invoke(null, (byte)2);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

