/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.IPlatformDependent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PlatformResolver {
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^(?<package>.+)\\.(?<class>[\\w]*)$");
    private static final Pattern INTERFACE_NAME_PATTERN = Pattern.compile("^(?<package>.+)\\.I(?<class>[\\w]*)$");

    @NotNull
    public static <T extends IPlatformDependent> T createPlatformInstance(Class<T> clazz) {
        Matcher classMatcher = (clazz.isInterface() ? INTERFACE_NAME_PATTERN : CLASS_NAME_PATTERN).matcher(clazz.getName());
        if (!classMatcher.matches()) {
            throw new IllegalArgumentException("The given class is not valid");
        }
        String className = classMatcher.group("package") + "." + classMatcher.group("class");
        return PlatformResolver.createPlatformInstance(clazz, className);
    }

    @NotNull
    public static <T extends IPlatformDependent> T createPlatformInstance(Class<T> clazz, @NotNull String className) {
        Class<?> tmp;
        StackTraceElement[] stackTraceElements = new Exception().getStackTrace();
        String runnerClass = stackTraceElements[stackTraceElements.length - 1].getClassName();
        if (runnerClass.contains("surefire") || runnerClass.contains("junit")) {
            return null;
        }
        if (PlatformResolver.getClass("net.glowstone.GlowServer") != null) {
            tmp = PlatformResolver.getClass(className + "_Glowstone");
        } else {
            String nmsServerVersion = MCVersion.CURRENT_VERSION.getIdentifier();
            tmp = PlatformResolver.getClass(className + "_" + nmsServerVersion);
            if (tmp == null) {
                tmp = PlatformResolver.getClass(className + "_Reflection");
            }
        }
        if (tmp == null) {
            throw new ClassNotFoundException("Could not find a platform implementation for " + clazz.getName());
        }
        if (tmp.isInterface()) {
            throw new IllegalStateException("Found platform class '" + tmp.getName() + "' is an interface!");
        }
        if (tmp.isInstance(clazz)) {
            throw new IllegalStateException("Found platform class '" + tmp.getName() + "' is not of the expected type!");
        }
        return (T)((IPlatformDependent)tmp.newInstance());
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

