/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Particles;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Particles.Particle;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Particles.ParticleSpawner;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.IUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

abstract class ParticleSpawnerBukkitNMSBase
extends ParticleSpawner {
    private static final Method METHOD_MATERIAL_DATA_GET_ITEM_TYPE_ID = MCVersion.isOlderThan(MCVersion.MC_1_13) ? Reflection.getMethod(MaterialData.class, "getItemTypeId", new Class[0]) : null;

    ParticleSpawnerBukkitNMSBase() {
    }

    @Override
    public void spawnParticle(Location location, Particle type, Object particleData, double visibleRange, int count, float offsetX, float offsetY, float offsetZ, float speed) {
        int[] data;
        if (type.getDataType().equals(ItemStack.class)) {
            if (!(particleData instanceof ItemStack)) {
                data = new int[]{0, 0};
            } else {
                ItemStack its = (ItemStack)particleData;
                data = new int[]{its.getType().getId(), its.getDurability()};
            }
        } else if (type.getDataType().equals(MaterialData.class)) {
            if (!(particleData instanceof MaterialData) && !(particleData instanceof ItemStack)) {
                data = new int[]{0};
            } else {
                MaterialData matData;
                MaterialData materialData = matData = particleData instanceof MaterialData ? (MaterialData)particleData : ((ItemStack)particleData).getData();
                if (METHOD_MATERIAL_DATA_GET_ITEM_TYPE_ID != null) {
                    try {
                        data = new int[]{(Integer)METHOD_MATERIAL_DATA_GET_ITEM_TYPE_ID.invoke((Object)matData, new Object[0]) + (matData.getData() << 12)};
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        data = new int[]{0};
                        e.printStackTrace();
                    }
                } else {
                    data = new int[]{0};
                }
            }
        } else {
            data = new int[]{};
        }
        this.spawnParticle(location, type, visibleRange, count, offsetX, offsetY, offsetZ, speed, data);
    }

    protected void spawnParticle(Location location, double visibleRange, Object particlePacket) throws IllegalAccessException, InvocationTargetException {
        if (particlePacket == null) {
            return;
        }
        double visibleRangeSquared = visibleRange * visibleRange;
        String worldName = location.getWorld().getName();
        for (Player player : location.getWorld().getPlayers()) {
            if (!player.getLocation().getWorld().getName().equalsIgnoreCase(worldName) || !(player.getLocation().distanceSquared(location) < visibleRangeSquared)) continue;
            IUtils.INSTANCE.sendPacket(player, particlePacket);
        }
    }

    protected abstract void spawnParticle(Location var1, Particle var2, double var3, int var5, float var6, float var7, float var8, float var9, int[] var10);
}

