/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Particles;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Particle {
    EXPLOSION("explode", "EXPLOSION_NORMAL"),
    EXPLOSION_LARGE("largeexplosion"),
    EXPLOSION_HUGE("hugeexplosion"),
    FIREWORKS_SPARK("fireworksSpark"),
    BUBBLE("bubble", "WATER_BUBBLE"),
    WAKE("wake", "WATER_WAKE"),
    SPLASH("splash", "WATER_SPLASH"),
    SUSPENDED,
    TOWNAURA("townaura", "TOWN_AURA"),
    CRIT,
    MAGIC_CRIT("magicCrit", "CRIT_MAGIC"),
    SMOKE("smoke", "SMOKE_NORMAL"),
    SMOKE_LARGE("largesmoke"),
    SPELL,
    SPELL_MOB("mobSpell"),
    SPELL_INSTANT("instantSpell"),
    SPELL_MOB_AMBIENT("mobSpellAmbient"),
    SPELL_WITCH("witchMagic"),
    DRIP_WATER("dripWater"),
    DRIP_LAVA("dripLava"),
    VILLAGER_ANGRY("angryVillager"),
    VILLAGER_HAPPY("happyVillager"),
    DEPTHSUSPEND("depthsuspend", "SUSPENDED_DEPTH"),
    NOTE,
    PORTAL,
    ENCHANTMENTTABLE("enchantmenttable", "ENCHANTMENT_TABLE"),
    FLAME,
    LAVA,
    FOOTSTEP,
    CLOUD,
    REDSTONEDUST("reddust", "REDSTONE"),
    SNOWBALL("snowballpoof"),
    SNOWSHOVEL("snowshovel", "SNOW_SHOVEL"),
    SLIME,
    HEART,
    BARRIER(MCVersion.MC_1_8),
    WATER_DROP(MCVersion.MC_1_8),
    ITEM_TAKE(MCVersion.MC_1_8),
    MOB_APPEARANCE(MCVersion.MC_1_8),
    ITEM_CRACK(MCVersion.MC_1_8, ItemStack.class),
    BLOCK_CRACK(MCVersion.MC_1_8, MaterialData.class),
    BLOCK_DUST(MCVersion.MC_1_8, MaterialData.class),
    SWEEP_ATTACK(MCVersion.MC_1_9),
    DRAGON_BREATH(MCVersion.MC_1_9),
    END_ROD(MCVersion.MC_1_9),
    DAMAGE_INDICATOR(MCVersion.MC_1_9),
    FALLING_DUST(MCVersion.MC_1_10, MaterialData.class),
    TOTEM(MCVersion.MC_1_11),
    SPIT(MCVersion.MC_1_11);

    private static final Map<String, Particle> BY_NAME;
    private final String oldName;
    private final String name;
    private final Class<?> dataType;
    private final MCVersion minVersion;

    private Particle(MCVersion minVersion) {
        this.name = this.name();
        this.oldName = this.name.toLowerCase(Locale.ENGLISH);
        this.minVersion = minVersion;
        this.dataType = Void.class;
    }

    private Particle(MCVersion minVersion, String bukkitName) {
        this.name = bukkitName;
        this.oldName = this.name.toLowerCase(Locale.ENGLISH);
        this.minVersion = minVersion;
        this.dataType = Void.class;
    }

    private Particle(MCVersion minVersion, Class<?> dataType) {
        this.name = this.name();
        this.oldName = this.name.toLowerCase(Locale.ENGLISH);
        this.minVersion = minVersion;
        this.dataType = dataType;
    }

    private Particle() {
        this.oldName = this.name().toLowerCase(Locale.ENGLISH);
        this.name = this.name();
        this.minVersion = MCVersion.MC_1_7;
        this.dataType = Void.class;
    }

    private Particle(String oldName) {
        this.oldName = oldName;
        this.name = this.name();
        this.minVersion = MCVersion.MC_1_7;
        this.dataType = Void.class;
    }

    private Particle(String oldName, String bukkitName) {
        this.oldName = oldName;
        this.name = bukkitName;
        this.minVersion = MCVersion.MC_1_7;
        this.dataType = Void.class;
    }

    @NotNull
    public String getOldNameUpperCase() {
        return this.getOldName().toUpperCase(Locale.ROOT);
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    @Nullable
    public static Particle getFrom(Enum<?> bukkitParticle) {
        return BY_NAME.get(bukkitParticle.name());
    }

    @Generated
    public String getOldName() {
        return this.oldName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public MCVersion getMinVersion() {
        return this.minVersion;
    }

    static {
        BY_NAME = new HashMap<String, Particle>();
        for (Particle particle : Particle.values()) {
            BY_NAME.put(particle.getName(), particle);
        }
    }
}

