/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.NMSReflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.NmsReflector;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NMSReflectionRemapped
implements NmsReflector {
    private static final Map<String, Class<?>> CLASS_MAP = new ConcurrentHashMap();
    private static final Map<String, String> CLASS_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> FIELD_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> METHOD_NAME_MAP = new HashMap<String, String>();

    private static void loadMappings(@NotNull Map<String, String> map, @NotNull String type) {
        InputStream fieldMappingStream = NMSReflectionRemapped.class.getClassLoader().getResourceAsStream("mappings/" + MCVersion.CURRENT_VERSION.getIdentifier() + "/" + type + "Mappings.txt");
        if (fieldMappingStream == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(fieldMappingStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] l;
                if (line.startsWith("#") || (l = line.split(" ")).length != 2) continue;
                map.put(l[0], l[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> findClass(@NotNull String className) {
        try (ZipInputStream zipStream = new ZipInputStream(Bukkit.getServer().getClass().getProtectionDomain().getCodeSource().getLocation().openStream());){
            ZipEntry e;
            String name;
            do {
                if ((e = zipStream.getNextEntry()) == null) return null;
            } while (!(name = e.getName()).startsWith("net/minecraft") || !name.endsWith("/" + className + ".class"));
            name = name.replace('/', '.');
            name = name.substring(0, name.length() - ".class".length());
            Class<?> clazz = Reflection.getClass(name);
            return clazz;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Nullable
    public Class<?> getNmsClass(@NotNull String className) {
        Class<?> clazz = CLASS_MAP.get(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = Reflection.getClassSilent(CLASS_NAME_MAP.getOrDefault(className, NMSReflection.NMS_CLASS_PATH + className));
        if (clazz == null) {
            clazz = this.findClass(className);
        }
        if (clazz == null) {
            Reflection.getClass(className);
        }
        if (clazz != null) {
            CLASS_MAP.put(className, clazz);
        }
        return clazz;
    }

    @Override
    @Contract(value="null,_,_->null")
    @Nullable
    public Method getNmsMethod(@Nullable Class<?> clazz, @NotNull String name, Class<?> ... args) {
        if (clazz == null) {
            return null;
        }
        String remapped = METHOD_NAME_MAP.get(clazz.getName() + "#" + name);
        if (remapped != null) {
            name = remapped;
        }
        return Reflection.getMethod(clazz, name, args);
    }

    @Override
    @Contract(value="null,_->null")
    @Nullable
    public Field getNmsField(@Nullable Class<?> clazz, @NotNull String name) {
        if (clazz == null) {
            return null;
        }
        String remapped = FIELD_NAME_MAP.get(clazz.getName() + "#" + name);
        if (remapped != null) {
            name = remapped;
        }
        return Reflection.getField(clazz, name);
    }

    @Override
    @Nullable
    public Enum<?> getNmsEnum(@NotNull String enumClassAndEnumName) {
        int i = enumClassAndEnumName.lastIndexOf(46);
        if (i < 1) {
            throw new RuntimeException("Invalid class + enum name");
        }
        return this.getNmsEnum(enumClassAndEnumName.substring(0, i), enumClassAndEnumName.substring(i + 1));
    }

    @Override
    @Nullable
    public Enum<?> getNmsEnum(@NotNull String enumClass, @NotNull String enumName) {
        Class<?> clazz = this.getNmsClass(enumClass);
        if (clazz == null) {
            return null;
        }
        String remapped = FIELD_NAME_MAP.get(clazz.getName() + "#" + enumName);
        if (remapped != null) {
            enumName = remapped;
        }
        return Reflection.getEnum(clazz, enumName);
    }

    static {
        NMSReflectionRemapped.loadMappings(CLASS_NAME_MAP, "Class");
        NMSReflectionRemapped.loadMappings(FIELD_NAME_MAP, "Field");
        NMSReflectionRemapped.loadMappings(METHOD_NAME_MAP, "Method");
    }
}

