/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit;

import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecraftMaterial {
    private final Material material;
    private final short dataValue;

    @Nullable
    public static MinecraftMaterial fromInput(@NotNull String input) {
        Material material;
        String[] inputs = input.split(":");
        short dataValue = -1;
        if (inputs.length == 2) {
            try {
                dataValue = Short.parseShort(inputs[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (material = Material.matchMaterial((String)inputs[0])) == null ? null : new MinecraftMaterial(material, dataValue);
    }

    public MinecraftMaterial(@NotNull Material material) {
        this(material, -1);
    }

    public MinecraftMaterial(@NotNull Material material, short dataValue) {
        this.material = material;
        this.dataValue = dataValue;
    }

    public MinecraftMaterial(@NotNull ItemStack itemStack) {
        this(itemStack.getType(), itemStack.getDurability());
    }

    public MinecraftMaterial(@NotNull Block block) {
        this(block.getType(), block.getData());
    }

    public boolean is(@Nullable Material material, short dataValue) {
        return material == this.getMaterial() && dataValue == this.getDataValue();
    }

    @Contract(value="null->false")
    public boolean is(@Nullable Object object) {
        if (object instanceof ItemStack) {
            return ((ItemStack)object).getType() == this.getMaterial() && (((ItemStack)object).getDurability() == this.getDataValue() || this.getDataValue() == -1);
        }
        if (object instanceof Block) {
            return ((Block)object).getType() == this.getMaterial() && (((Block)object).getData() == this.getDataValue() || this.getDataValue() == -1);
        }
        if (object instanceof Material) {
            return object == this.getMaterial();
        }
        if (object instanceof MinecraftMaterial) {
            return ((MinecraftMaterial)object).getMaterial() == this.getMaterial() && (((MinecraftMaterial)object).getDataValue() == this.getDataValue() || this.getDataValue() == -1 || ((MinecraftMaterial)object).getDataValue() == -1);
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public boolean equals(@Nullable Material material, short dataValue) {
        return this.is(material, dataValue);
    }

    public boolean equals(@Nullable Object object) {
        return this.is(object);
    }

    public int hashCode() {
        return this.material.hashCode();
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public short getDataValue() {
        return this.dataValue;
    }
}

