/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.ActionBarSender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.ChatSender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.DisabledSender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.ISender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.TitleSender;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.ISendMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.TitleMetadata;
import java.util.Collection;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SendMethod implements ISendMethod,
ISender
{
    CHAT_CLASSIC(new DisabledSender(), null),
    CHAT(MCVersion.isOlderThan(MCVersion.MC_1_8) ? null : new ChatSender(), CHAT_CLASSIC),
    TITLE(MCVersion.isOlderThan(MCVersion.MC_1_8) ? null : new TitleSender(), TitleMetadata.class, TitleMetadata::new, CHAT),
    ACTION_BAR(MCVersion.isOlderThan(MCVersion.MC_1_8) ? null : new ActionBarSender(), CHAT),
    DISABLED(new DisabledSender(), null);

    @Nullable
    private final ISender sender;
    @NotNull
    private final ISender activeSender;
    @Nullable
    private final Class<? extends IMetadata> metadataClass;
    @NotNull
    private final SendMethod fallbackSendMethod;
    @Nullable
    private final Supplier<? extends IMetadata> metadataSupplier;

    private SendMethod(ISender sender, SendMethod fallback) {
        this(sender, null, null, fallback);
    }

    private SendMethod(@Nullable ISender sender, @Nullable Class<? extends IMetadata> metadataClass, Supplier<? extends IMetadata> metadataSupplier, SendMethod fallback) {
        this.sender = sender;
        this.metadataClass = metadataClass;
        this.metadataSupplier = metadataSupplier;
        if (fallback != null) {
            if (!fallback.isAvailable()) {
                fallback = fallback.getFallbackSendMethod();
            }
        } else {
            fallback = this;
        }
        this.fallbackSendMethod = fallback;
        this.activeSender = sender != null ? sender : fallback.getActiveSender();
    }

    public boolean isAvailable() {
        return this.sender != null;
    }

    public boolean hasMetadata() {
        return this.metadataClass != null;
    }

    @Override
    @Nullable
    public IMetadata parseMetadata(@NotNull String json) {
        if (this.metadataSupplier == null) {
            return null;
        }
        IMetadata metadata = this.metadataSupplier.get();
        metadata.parseJson(json);
        return metadata;
    }

    @Override
    public void send(@NotNull Player player, @NotNull String json) {
        this.activeSender.send(player, json);
    }

    @Override
    public void send(@NotNull Player player, @NotNull String json, @Nullable IMetadata optionalMetadata) {
        this.activeSender.send(player, json, optionalMetadata);
    }

    @Override
    public void send(@NotNull Collection<? extends Player> players, @NotNull String json) {
        this.activeSender.send(players, json);
    }

    @Override
    public void send(@NotNull Collection<? extends Player> players, @NotNull String json, @Nullable IMetadata optionalMetadata) {
        this.activeSender.send(players, json, optionalMetadata);
    }

    @Override
    public void broadcast(@NotNull String json) {
        this.activeSender.broadcast(json);
    }

    @Override
    public void broadcast(@NotNull String json, @Nullable IMetadata optionalMetadata) {
        this.activeSender.broadcast(json, optionalMetadata);
    }

    @Nullable
    @Generated
    public ISender getSender() {
        return this.sender;
    }

    @NotNull
    @Generated
    public ISender getActiveSender() {
        return this.activeSender;
    }

    @Override
    @Nullable
    @Generated
    public Class<? extends IMetadata> getMetadataClass() {
        return this.metadataClass;
    }

    @NotNull
    @Generated
    public SendMethod getFallbackSendMethod() {
        return this.fallbackSendMethod;
    }

    @Nullable
    @Generated
    public Supplier<? extends IMetadata> getMetadataSupplier() {
        return this.metadataSupplier;
    }
}

