/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors.Wrappers;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ItemNameResolver;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.InventoryUtils;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackWrapper {
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ItemNameResolver itemNameResolver;
    private String cachedName = null;
    private String cachedDisplayName = null;
    private String cachedMetadata = null;

    public ItemStackWrapper(@NotNull ItemStack itemStack, @NotNull Logger logger, @NotNull ItemNameResolver resolver) {
        this.itemStack = itemStack;
        this.logger = logger;
        this.itemNameResolver = resolver;
    }

    public String getItemName() {
        if (this.cachedName == null) {
            this.cachedName = this.itemNameResolver.getName(this.itemStack);
        }
        return this.cachedName;
    }

    public String getItemDisplayName() {
        if (this.cachedDisplayName == null) {
            this.cachedDisplayName = this.itemNameResolver.getDisplayName(this.itemStack);
        }
        return this.cachedDisplayName;
    }

    public String getItemMetadata() {
        if (this.cachedMetadata == null) {
            this.cachedMetadata = InventoryUtils.convertItemStackToJson(this.itemStack, this.logger);
        }
        return this.cachedMetadata;
    }

    public int getAmount() {
        return this.itemStack.getAmount();
    }

    @NotNull
    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

