/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Placeholder.Processors;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.GameMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameModePlaceholderProcessor
implements IPlaceholderProcessor {
    @NotNull
    private final Map<GameMode, String> gameModeTranslations;

    public GameModePlaceholderProcessor() {
        this(null);
    }

    public GameModePlaceholderProcessor(@Nullable Map<GameMode, String> translations) {
        this.gameModeTranslations = translations == null ? new EnumMap<GameMode, String>(GameMode.class) : new EnumMap<GameMode, String>(translations);
        for (GameMode gm : GameMode.values()) {
            this.gameModeTranslations.computeIfAbsent(gm, gameMode -> gameMode.name().toLowerCase(Locale.ROOT));
        }
    }

    @Override
    @NotNull
    public String process(@Nullable Object parameter) {
        if (parameter instanceof GameMode) {
            return this.gameModeTranslations.get(parameter);
        }
        if (parameter instanceof Collection) {
            StringBuilder builder = new StringBuilder("[");
            for (Object o : (Collection)parameter) {
                if (!(o instanceof GameMode)) continue;
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                builder.append(this.gameModeTranslations.get(o));
            }
            builder.append("]");
            return builder.toString();
        }
        return "unknown";
    }
}

