/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.IStatisticResolver;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.PlatformResolver;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.InventoryUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageHoverEvent;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public final class MessageTooltipFactory {
    private static final IStatisticResolver STATISTIC_RESOLVER = PlatformResolver.createPlatformInstance(IStatisticResolver.class);

    private MessageTooltipFactory() {
    }

    public static void achievementTooltip(MessageComponent messageComponent, Object achievement) {
        if (MCVersion.isOlderThan(MCVersion.MC_1_12)) {
            if (achievement instanceof Achievement) {
                messageComponent.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, STATISTIC_RESOLVER.getAchievementName((Achievement)achievement));
            }
        } else {
            throw new IllegalStateException("Achievements are not supported in your minecraft version!");
        }
    }

    public static void statisticTooltip(MessageComponent messageComponent, Statistic statistic) throws IllegalArgumentException {
        Statistic.Type type = statistic.getType();
        if (type != Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic requires an additional " + type + " parameter!");
        }
        messageComponent.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, STATISTIC_RESOLVER.getStatisticName(statistic));
    }

    public static void statisticTooltip(MessageComponent messageComponent, Statistic statistic, Material material) throws IllegalArgumentException {
        Statistic.Type type = statistic.getType();
        if (type == Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic needs no additional parameter!");
        }
        if (type == Statistic.Type.BLOCK && material.isBlock() || type == Statistic.Type.ENTITY) {
            throw new IllegalArgumentException("Wrong parameter type for that statistic - needs " + type + "!");
        }
        messageComponent.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, STATISTIC_RESOLVER.getStatisticName(statistic, material));
    }

    public static void statisticTooltip(MessageComponent messageComponent, Statistic statistic, EntityType entity) throws IllegalArgumentException {
        Statistic.Type type = statistic.getType();
        if (type == Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic needs no additional parameter!");
        }
        if (type != Statistic.Type.ENTITY) {
            throw new IllegalArgumentException("Wrong parameter type for that statistic - needs " + type + "!");
        }
        messageComponent.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, STATISTIC_RESOLVER.getStatisticName(statistic, entity));
    }

    public static void itemTooltip(MessageComponent messageComponent, ItemStack itemStack) {
        messageComponent.itemTooltip(InventoryUtils.convertItemStackToJson(itemStack, Bukkit.getLogger()));
    }
}

