/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message;

import at.pcgamingfreaks.Bukkit.Message.IMessage;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.MessageBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.BossBarMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Sender.SendMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.IUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.IMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.TitleMetadata;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Message
extends at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message<Message, Player, CommandSender>
implements IMessage {
    private static final Pattern RGB_COLOR_DETECTION;
    private static final boolean PRE_1_8_MC;
    @NotNull
    private SendMethod sendMethod;

    public Message(@NotNull String message) {
        super(message);
        SendMethod sendMethod = this.sendMethod = PRE_1_8_MC ? SendMethod.CHAT_CLASSIC : SendMethod.CHAT;
        if (!MCVersion.supportsRgbColors()) {
            boolean found = false;
            Matcher matcher = RGB_COLOR_DETECTION.matcher(this.json);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                found = true;
                MessageColor color = MessageColor.getDefaultColor(matcher.group("rgb"));
                matcher.appendReplacement(sb, color.getName());
            }
            if (found) {
                matcher.appendTail(sb);
                this.json = sb.toString();
            }
        }
    }

    public Message(@NotNull String message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull MessageComponent[] message) {
        this(Arrays.asList(message));
    }

    public Message(@NotNull MessageComponent[] message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull Collection<? extends MessageComponent> message) {
        super(message);
        this.sendMethod = PRE_1_8_MC ? SendMethod.CHAT_CLASSIC : SendMethod.CHAT;
    }

    public Message(@NotNull Collection<MessageComponent> message, @NotNull SendMethod method) {
        this(message);
        this.setSendMethod(method);
    }

    public Message(@NotNull MessageBuilder messageBuilder) {
        this(messageBuilder.getJsonMessageAsList());
    }

    public Message(@NotNull MessageBuilder messageBuilder, @NotNull SendMethod method) {
        this(messageBuilder.getJsonMessageAsList(), method);
    }

    public void setSendMethod(@Nullable SendMethod method) {
        if (method == null) {
            method = SendMethod.DISABLED;
        } else if (!method.isAvailable()) {
            method = method.getFallbackSendMethod();
        }
        this.sendMethod = method;
    }

    @Override
    public void setOptionalParameters(@NotNull IMetadata optionalParameters) {
        Validate.isTrue((optionalParameters instanceof TitleMetadata || optionalParameters instanceof BossBarMetadata ? 1 : 0) != 0, (String)"The metadata object needs to be an instance of TitleMetadata or BossBarMetadata");
        super.setOptionalParameters(optionalParameters);
    }

    @Override
    public void setPlaceholderApiEnabled(boolean enabled) {
        this.placeholderApiEnabled = enabled && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public void send(@NotNull CommandSender target, Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        Validate.notNull((Object)target, (String)"The target that should receive the message should not be null!");
        if (target instanceof Player && this.getSendMethod() != SendMethod.CHAT_CLASSIC) {
            String jsonMsg = this.prepareMessage(true, args);
            if (this.isPlaceholderApiEnabled()) {
                jsonMsg = PlaceholderAPI.setPlaceholders((Player)((Player)target), (String)jsonMsg);
            }
            this.sendMethod.getActiveSender().send((Player)target, jsonMsg, this.optionalParameters);
        } else {
            String msg = this.prepareMessage(false, args);
            if (this.isPlaceholderApiEnabled() && target instanceof Player) {
                msg = PlaceholderAPI.setPlaceholders((Player)((Player)target), (String)msg);
            }
            target.sendMessage(msg);
        }
    }

    public void send(@NotNull Collection<? extends Player> targets, Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED || targets.isEmpty()) {
            return;
        }
        Validate.notNull(targets, (String)"The targets that should receive the message should not be null!");
        if (this.getSendMethod() == SendMethod.CHAT_CLASSIC) {
            String msg = this.prepareMessage(false, args);
            for (Player player : targets) {
                player.sendMessage(this.isPlaceholderApiEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)msg) : msg);
            }
        } else {
            String jsonMsg = this.prepareMessage(true, args);
            if (this.isPlaceholderApiEnabled()) {
                for (Player player : targets) {
                    this.sendMethod.getActiveSender().send(player, PlaceholderAPI.setPlaceholders((Player)player, (String)jsonMsg));
                }
            } else {
                this.sendMethod.getActiveSender().send(targets, jsonMsg, this.optionalParameters);
            }
        }
    }

    public void broadcast(Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        if (this.getSendMethod() == SendMethod.CHAT_CLASSIC) {
            Bukkit.broadcastMessage((String)this.prepareMessage(false, args));
        } else {
            Bukkit.getConsoleSender().sendMessage(this.prepareMessage(false, args));
            this.sendMethod.getActiveSender().broadcast(this.prepareMessage(true, args), this.optionalParameters);
        }
    }

    public void send(@NotNull CommandSender target, @NotNull OfflinePlayer playerForPAPI, Object ... args) {
        Validate.notNull((Object)target, (String)"The target that should receive the message should not be null!");
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        if (target instanceof Player && this.getSendMethod() != SendMethod.CHAT_CLASSIC) {
            String jsonMsg = this.prepareMessage(true, args);
            if (this.isPlaceholderApiEnabled()) {
                jsonMsg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)jsonMsg);
            }
            this.sendMethod.getActiveSender().send((Player)target, jsonMsg, this.optionalParameters);
        } else {
            String msg = this.prepareMessage(false, args);
            if (this.isPlaceholderApiEnabled()) {
                msg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)msg);
            }
            target.sendMessage(msg);
        }
    }

    public void send(@NotNull Collection<? extends Player> targets, OfflinePlayer playerForPAPI, Object ... args) {
        Validate.notNull(targets, (String)"The targets that should receive the message should not be null!");
        if (this.getSendMethod() == SendMethod.DISABLED || targets.isEmpty()) {
            return;
        }
        if (this.getSendMethod() == SendMethod.CHAT_CLASSIC) {
            String msg = this.prepareMessage(false, args);
            if (this.isPlaceholderApiEnabled()) {
                msg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)msg);
            }
            for (Player player : targets) {
                player.sendMessage(msg);
            }
        } else {
            String jsonMsg = this.prepareMessage(true, args);
            if (this.isPlaceholderApiEnabled()) {
                jsonMsg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)jsonMsg);
            }
            this.sendMethod.getActiveSender().send(targets, jsonMsg, this.optionalParameters);
        }
    }

    public void broadcast(@NotNull OfflinePlayer playerForPAPI, Object ... args) {
        if (this.getSendMethod() == SendMethod.DISABLED) {
            return;
        }
        String msg = this.prepareMessage(false, args);
        if (this.isPlaceholderApiEnabled()) {
            msg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)msg);
        }
        if (this.getSendMethod() == SendMethod.CHAT_CLASSIC) {
            Bukkit.broadcastMessage((String)msg);
        } else {
            Bukkit.getConsoleSender().sendMessage(msg);
            String jsonMsg = this.prepareMessage(true, args);
            if (this.isPlaceholderApiEnabled()) {
                jsonMsg = PlaceholderAPI.setPlaceholders((OfflinePlayer)playerForPAPI, (String)jsonMsg);
            }
            this.sendMethod.broadcast(jsonMsg, this.optionalParameters);
        }
    }

    @NotNull
    public String prepareChatLegacy(Object ... args) {
        return this.prepareMessage(false, args);
    }

    @NotNull
    public Object prepareChatComponent(Object ... args) {
        String json = this.prepareMessage(true, args);
        return IUtils.INSTANCE.jsonToIChatComponent(json);
    }

    @NotNull
    @Generated
    public SendMethod getSendMethod() {
        return this.sendMethod;
    }

    static {
        Constructor builderConstructor = null;
        try {
            builderConstructor = MessageBuilder.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Message.setMessageComponentClass(builderConstructor);
        RGB_COLOR_DETECTION = Pattern.compile("\"color\"\\s*:\\s*\"#(?<rgb>[\\dA-Fa-f]{6})\"");
        PRE_1_8_MC = MCVersion.isOlderThan(MCVersion.MC_1_8);
    }
}

