/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ItemStackSerializer;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.ItemStackSerializer.ItemStackSerializer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.NmsReflector;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.OBCReflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NBTItemStackSerializer_Reflection
implements ItemStackSerializer {
    private static final Class<?> CLASS_NBT_BASE = NmsReflector.INSTANCE.getNmsClass("NBTBase");
    private static final Class<?> CLASS_NBT_TAG_COMPOUND = NmsReflector.INSTANCE.getNmsClass("NBTTagCompound");
    private static final Class<?> CLASS_NBT_TAG_LIST = NmsReflector.INSTANCE.getNmsClass("NBTTagList");
    private static final Class<?> CLASS_NBT_COMPRESSED_STREAM_TOOLS = NmsReflector.INSTANCE.getNmsClass("NBTCompressedStreamTools");
    private static final Class<?> CLASS_NMS_ITEM_STACK = NmsReflector.INSTANCE.getNmsClass("ItemStack");
    private static final Class<?> CLASS_CRAFT_ITEM_STACK = OBCReflection.getOBCClass("inventory.CraftItemStack");
    private static final Constructor<?> CONSTRUCTOR_NBT_TAG_COMPOUND = Reflection.getConstructor(CLASS_NBT_TAG_COMPOUND, new Class[0]);
    private static final Constructor<?> CONSTRUCTOR_NBT_TAG_LIST = Reflection.getConstructor(CLASS_NBT_TAG_LIST, new Class[0]);
    private static final Constructor<?> CONSTRUCTOR_NMS_ITEM_STACK = MCVersion.isNewerOrEqualThan(MCVersion.MC_1_11) && MCVersion.isOlderThan(MCVersion.MC_1_13) ? Reflection.getConstructor(CLASS_NMS_ITEM_STACK, CLASS_NBT_TAG_COMPOUND) : null;
    private static final Method METHOD_NBT_TAG_C_SET_INT = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "setInt", String.class, Integer.TYPE);
    private static final Method METHOD_NBT_TAG_C_SET_BYTE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "setByte", String.class, Byte.TYPE);
    private static final Method METHOD_NBT_TAG_C_SET_NBT_BASE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "set", String.class, CLASS_NBT_BASE);
    private static final Method METHOD_NBT_TAG_LIST_ADD = MCVersion.isOlderThan(MCVersion.MC_1_14) ? NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_LIST, "add", CLASS_NBT_BASE) : NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_LIST, "b", Integer.TYPE, CLASS_NBT_BASE);
    private static final Method METHOD_NBT_COMP_STEAM_A = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_COMPRESSED_STREAM_TOOLS, "a", CLASS_NBT_TAG_COMPOUND, OutputStream.class);
    private static final Method METHOD_NBT_TAG_C_SET2 = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "set", String.class, NmsReflector.INSTANCE.getNmsClass("NBTBase"));
    private static final Method METHOD_SAVE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NMS_ITEM_STACK, "save", CLASS_NBT_TAG_COMPOUND);
    private static final Method METHOD_AS_NMS_COPY = Reflection.getMethod(CLASS_CRAFT_ITEM_STACK, "asNMSCopy", ItemStack.class);
    private static final Method METHOD_GET_INT = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "getInt", String.class);
    private static final Method METHOD_GET_BYTE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "getByte", String.class);
    private static final Method METHOD_HAS_KEY_OF_TYPE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "hasKeyOfType", String.class, Integer.TYPE);
    private static final Method METHOD_GET_COMPOUND = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "getCompound", String.class);
    private static final Method METHOD_GET_COMPOUND_LIST = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_COMPOUND, "getList", String.class, Integer.TYPE);
    private static final Method METHOD_GET_COMPOUND_FROM_LIST;
    private static final Method METHOD_CREATE_STACK;
    private static final Method METHOD_AS_BUKKIT_COPY;
    private static final Method METHOD_NBT_COMP_STREAM_A2;
    private static final Method METHOD_NBT_TAG_LIST_SIZE;
    private static final Method METHOD_DATA_FIXER_UPDATE;
    private static final Enum<?> ENUM_DATA_FIX_TYPE;
    private static final Object DATA_FIXER;
    private static final int CURRENT_DATA_VERSION;
    private static final String KEY_INVENTORY = "Inventory";
    private static final String KEY_DATA_VERSION = "DataVersion";
    private Logger logger = null;

    @Override
    public void setLogger(@Nullable Logger logger) {
        this.logger = logger;
        if (logger == null) {
            return;
        }
        if (CLASS_NBT_TAG_COMPOUND == null || METHOD_NBT_TAG_C_SET2 == null || METHOD_NBT_TAG_C_SET_INT == null || METHOD_SAVE == null || METHOD_AS_NMS_COPY == null || METHOD_NBT_COMP_STEAM_A == null || METHOD_NBT_COMP_STREAM_A2 == null || METHOD_GET_INT == null || METHOD_HAS_KEY_OF_TYPE == null || METHOD_AS_BUKKIT_COPY == null || METHOD_GET_COMPOUND == null || METHOD_CREATE_STACK == null && CONSTRUCTOR_NMS_ITEM_STACK == null) {
            logger.warning("It seems like the system wasn't able to find some Bukkit/Minecraft classes and/or methods.\nIs the plugin up-to-date and compatible with the used server version?\nBukkit Version: " + Bukkit.getVersion());
        }
    }

    private void convertOldFormatToNew(Object localNBTTagCompound, int size) throws Exception {
        Object nbtItemList = CONSTRUCTOR_NBT_TAG_LIST.newInstance(new Object[0]);
        METHOD_NBT_TAG_C_SET_NBT_BASE.invoke(localNBTTagCompound, KEY_INVENTORY, nbtItemList);
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)METHOD_HAS_KEY_OF_TYPE.invoke(localNBTTagCompound, String.valueOf(i), 10)).booleanValue()) continue;
            Object itemNBTCompound = METHOD_GET_COMPOUND.invoke(localNBTTagCompound, String.valueOf(i));
            METHOD_NBT_TAG_C_SET_BYTE.invoke(itemNBTCompound, "Slot", (byte)i);
            METHOD_NBT_TAG_LIST_ADD.invoke(nbtItemList, itemNBTCompound);
        }
    }

    @Override
    public ItemStack[] deserialize(byte[] data) {
        if (data != null) {
            try {
                Object localNBTTagCompound = METHOD_NBT_COMP_STREAM_A2.invoke(null, new ByteArrayInputStream(data));
                int size = (Integer)METHOD_GET_INT.invoke(localNBTTagCompound, "size");
                int dataVersion = CURRENT_DATA_VERSION;
                if (((Boolean)METHOD_HAS_KEY_OF_TYPE.invoke(localNBTTagCompound, KEY_DATA_VERSION, 3)).booleanValue()) {
                    dataVersion = (Integer)METHOD_GET_INT.invoke(localNBTTagCompound, KEY_DATA_VERSION);
                }
                if (!((Boolean)METHOD_HAS_KEY_OF_TYPE.invoke(localNBTTagCompound, KEY_INVENTORY, 9)).booleanValue()) {
                    this.convertOldFormatToNew(localNBTTagCompound, size);
                }
                if (MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) && dataVersion < CURRENT_DATA_VERSION) {
                    localNBTTagCompound = METHOD_DATA_FIXER_UPDATE.invoke(null, DATA_FIXER, ENUM_DATA_FIX_TYPE, localNBTTagCompound, dataVersion);
                }
                ItemStack[] its = new ItemStack[size];
                Object nbtItemList = METHOD_GET_COMPOUND_LIST.invoke(localNBTTagCompound, KEY_INVENTORY, 10);
                int listSize = (Integer)METHOD_NBT_TAG_LIST_SIZE.invoke(nbtItemList, new Object[0]);
                for (int i = 0; i < listSize; ++i) {
                    Object compound = METHOD_GET_COMPOUND_FROM_LIST.invoke(nbtItemList, i);
                    byte slot = (Byte)METHOD_GET_BYTE.invoke(compound, "Slot");
                    try {
                        its[slot] = NBTItemStackSerializer_Reflection.deserializeNBTCompound(compound);
                        continue;
                    }
                    catch (Exception ignored) {
                        if (this.logger == null) continue;
                        this.logger.warning("Failed to restore item on slot " + i + " with json:\n" + compound.toString());
                    }
                }
                return its;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    private static ItemStack deserializeNBTCompound(@NotNull Object compound) throws Exception {
        Object nmsItemStack = MCVersion.isNewerOrEqualThan(MCVersion.MC_1_11) && MCVersion.isOlderThan(MCVersion.MC_1_13) ? CONSTRUCTOR_NMS_ITEM_STACK.newInstance(compound) : METHOD_CREATE_STACK.invoke(null, compound);
        return nmsItemStack != null ? (ItemStack)METHOD_AS_BUKKIT_COPY.invoke(null, nmsItemStack) : null;
    }

    @Override
    public byte[] serialize(ItemStack[] itemStacks) {
        byte[] ba = null;
        if (itemStacks != null) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                Object localNBTTagCompound = CONSTRUCTOR_NBT_TAG_COMPOUND.newInstance(new Object[0]);
                METHOD_NBT_TAG_C_SET_INT.invoke(localNBTTagCompound, "size", itemStacks.length);
                METHOD_NBT_TAG_C_SET_INT.invoke(localNBTTagCompound, KEY_DATA_VERSION, CURRENT_DATA_VERSION);
                Object nbtItemList = CONSTRUCTOR_NBT_TAG_LIST.newInstance(new Object[0]);
                METHOD_NBT_TAG_C_SET_NBT_BASE.invoke(localNBTTagCompound, KEY_INVENTORY, nbtItemList);
                int used = -1;
                for (int i = 0; i < itemStacks.length; ++i) {
                    if (itemStacks[i] == null) continue;
                    Object itemNBTCompound = CONSTRUCTOR_NBT_TAG_COMPOUND.newInstance(new Object[0]);
                    METHOD_NBT_TAG_C_SET_BYTE.invoke(itemNBTCompound, "Slot", (byte)i);
                    METHOD_SAVE.invoke(METHOD_AS_NMS_COPY.invoke(null, itemStacks[i]), itemNBTCompound);
                    if (MCVersion.isOlderThan(MCVersion.MC_1_14)) {
                        METHOD_NBT_TAG_LIST_ADD.invoke(nbtItemList, itemNBTCompound);
                        continue;
                    }
                    METHOD_NBT_TAG_LIST_ADD.invoke(nbtItemList, ++used, itemNBTCompound);
                }
                METHOD_NBT_COMP_STEAM_A.invoke(null, localNBTTagCompound, dataOutputStream);
                dataOutputStream.flush();
                ba = byteArrayOutputStream.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ba;
    }

    @Override
    public boolean checkIsMCVersionCompatible() {
        return NBTItemStackSerializer_Reflection.isMCVersionCompatible();
    }

    public static boolean isMCVersionCompatible() {
        return MCVersion.isNewerOrEqualThan(MCVersion.MC_1_7) && MCVersion.isOlderOrEqualThan(MCVersion.MC_NMS_1_19_R1_1);
    }

    static {
        Method method = METHOD_GET_COMPOUND_FROM_LIST = MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_LIST, "getCompound", Integer.TYPE) : NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_LIST, "get", Integer.TYPE);
        METHOD_CREATE_STACK = MCVersion.isOlderThan(MCVersion.MC_1_11) ? NmsReflector.INSTANCE.getNmsMethod(CLASS_NMS_ITEM_STACK, "createStack", CLASS_NBT_TAG_COMPOUND) : (MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13) ? NmsReflector.INSTANCE.getNmsMethod(CLASS_NMS_ITEM_STACK, "a", CLASS_NBT_TAG_COMPOUND) : null);
        METHOD_AS_BUKKIT_COPY = Reflection.getMethod(CLASS_CRAFT_ITEM_STACK, "asBukkitCopy", CLASS_NMS_ITEM_STACK);
        METHOD_NBT_COMP_STREAM_A2 = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_COMPRESSED_STREAM_TOOLS, "a", InputStream.class);
        METHOD_NBT_TAG_LIST_SIZE = NmsReflector.INSTANCE.getNmsMethod(CLASS_NBT_TAG_LIST, "size", new Class[0]);
        Object dataFixer = null;
        Method fixerUpdate = null;
        Enum<?> fixType = null;
        if (MCVersion.isNewerOrEqualThan(MCVersion.MC_1_13)) {
            try {
                dataFixer = MCVersion.isOlderThan(MCVersion.MC_1_17) ? NmsReflector.INSTANCE.getNmsField("MinecraftServer", "dataConverterManager").get(OBCReflection.getOBCMethod("CraftServer", "getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0])) : NmsReflector.INSTANCE.getNmsMethod("MinecraftServer", "getDataFixer", new Class[0]).invoke(OBCReflection.getOBCMethod("CraftServer", "getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]), new Object[0]);
                if (MCVersion.isOlderThan(MCVersion.MC_1_14)) {
                    fixerUpdate = NmsReflector.INSTANCE.getNmsMethod("GameProfileSerializer", "a", Reflection.getClass("com.mojang.datafixers.DataFixer"), Reflection.getClass("com.mojang.datafixers.DSL$TypeReference"), CLASS_NBT_TAG_COMPOUND, Integer.TYPE);
                    fixType = Reflection.getEnum(Reflection.getClass("com.mojang.datafixers.DataFixTypes"), "PLAYER");
                } else {
                    fixerUpdate = NmsReflector.INSTANCE.getNmsMethod("GameProfileSerializer", "a", Reflection.getClass("com.mojang.datafixers.DataFixer"), NmsReflector.INSTANCE.getNmsClass("DataFixTypes"), CLASS_NBT_TAG_COMPOUND, Integer.TYPE);
                    fixType = NmsReflector.INSTANCE.getNmsEnum("DataFixTypes", "PLAYER");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DATA_FIXER = dataFixer;
        METHOD_DATA_FIXER_UPDATE = fixerUpdate;
        ENUM_DATA_FIX_TYPE = fixType;
        if (MCVersion.isOlderOrEqualThan(MCVersion.MC_NMS_1_9_R1)) {
            CURRENT_DATA_VERSION = 176;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_9_R2)) {
            CURRENT_DATA_VERSION = 184;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_10_R1)) {
            CURRENT_DATA_VERSION = 512;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_11_R1)) {
            CURRENT_DATA_VERSION = 922;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_12_R1)) {
            CURRENT_DATA_VERSION = 1343;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_13_R1)) {
            CURRENT_DATA_VERSION = 1519;
        } else if (MCVersion.is(MCVersion.MC_NMS_1_13_R2)) {
            CURRENT_DATA_VERSION = 1631;
        } else if (MCVersion.isNewerOrEqualThan(MCVersion.MC_NMS_1_14_R1)) {
            String getGameVersion = MCVersion.isOlderThan(MCVersion.MC_NMS_1_15_R1) ? "a" : "getGameVersion";
            int version = -1;
            try {
                Method methodSharedConstantsGetGameVersion = NmsReflector.INSTANCE.getNmsMethod("SharedConstants", getGameVersion, new Class[0]);
                Object gameVersion = methodSharedConstantsGetGameVersion.invoke(null, new Object[0]);
                Method methodGameVersionGetWorldVersion = Reflection.getMethod(Reflection.getClass("com.mojang.bridge.game.GameVersion"), "getWorldVersion", new Class[0]);
                version = (Integer)methodGameVersionGetWorldVersion.invoke(gameVersion, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CURRENT_DATA_VERSION = version;
        } else {
            CURRENT_DATA_VERSION = -1;
        }
    }
}

