/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Language;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MinecraftMaterial;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.ILanguageConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ItemNameResolver {
    private static final String LOADING_MESSAGE = "Loading item translations ...";
    private static final String FINISHED_LOADING_MESSAGE = "Finished loading item translations for {0} items.";
    private final Map<Material, Map<Short, String>> names = new HashMap<Material, Map<Short, String>>();

    public void load(@NotNull IPlugin plugin, @NotNull ILanguageConfiguration configuration) {
        if (MCVersion.isOlderThan(MCVersion.MC_1_13)) {
            at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language itemNameLanguage = new at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language(plugin, new Version(1), File.separator + "lang", "items_", "legacy_items_");
            itemNameLanguage.setFileDescription("item name language");
            itemNameLanguage.load(configuration);
            this.loadLegacy(itemNameLanguage, plugin.getLogger());
        } else {
            at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language itemNameLanguage = new at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language(plugin, new Version(2), File.separator + "lang", "items_");
            itemNameLanguage.setFileDescription("item name language");
            itemNameLanguage.load(configuration);
            this.load(itemNameLanguage, plugin.getLogger());
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public void load(@NotNull Language language, @NotNull Logger logger) {
        if (!language.isLoaded()) {
            return;
        }
        logger.info(LOADING_MESSAGE);
        int translationCount = 0;
        for (String key : language.getLang().getKeys(true)) {
            if (!key.startsWith("Items")) continue;
            String material = key.substring(6);
            String suffix = "";
            Material mat = Material.matchMaterial((String)material);
            if (mat == null) continue;
            this.names.computeIfAbsent(mat, k -> new HashMap());
            this.names.get(mat).put((short)-1, language.getRaw(key, "") + suffix);
            ++translationCount;
        }
        logger.log(Level.INFO, FINISHED_LOADING_MESSAGE, translationCount);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
    public void loadLegacy(@NotNull Language language, @NotNull Logger logger) {
        if (!language.isLoaded()) {
            return;
        }
        logger.info(LOADING_MESSAGE);
        int translationCount = 0;
        Iterator<String> iterator = language.getLang().getKeys(true).iterator();
        while (iterator.hasNext()) {
            Material mat;
            String key;
            String material = key = iterator.next();
            String suffix = "";
            short dataValue = -1;
            if (key.contains(".") || key.contains(":")) {
                String[] components = key.split("[.:]");
                material = components[0];
                if (components[1].equals("appendDefault")) continue;
                dataValue = Utils.tryParse(components[1], (short)-1);
                if (language.getLang().getBoolean(material + ".appendDefault", false)) {
                    suffix = language.getRaw(material, language.getRaw(material + ".default", ""));
                }
            }
            if ((mat = Material.matchMaterial((String)material)) == null) continue;
            this.names.computeIfAbsent(mat, k -> new HashMap());
            this.names.get(mat).put(dataValue, language.getRaw(key, "") + suffix);
            ++translationCount;
        }
        logger.log(Level.INFO, FINISHED_LOADING_MESSAGE, translationCount);
    }

    private void load(at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language language, @NotNull Logger logger) {
        if (!language.isLoaded()) {
            return;
        }
        logger.info(LOADING_MESSAGE);
        int translationCount = 0;
        for (String key : language.getLang().getKeys(true)) {
            if (!key.startsWith("Items")) continue;
            String material = key.substring(6);
            String suffix = "";
            short dataValue = -1;
            Material mat = Material.matchMaterial((String)material);
            if (mat == null) continue;
            this.names.computeIfAbsent(mat, k -> new HashMap());
            this.names.get(mat).put(dataValue, language.getRaw(key, "") + suffix);
            ++translationCount;
        }
        logger.log(Level.INFO, FINISHED_LOADING_MESSAGE, translationCount);
    }

    private void loadLegacy(at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language language, @NotNull Logger logger) {
        if (!language.isLoaded()) {
            return;
        }
        logger.info(LOADING_MESSAGE);
        int translationCount = 0;
        Iterator<String> iterator = language.getLang().getKeys(true).iterator();
        while (iterator.hasNext()) {
            Material mat;
            String key;
            String material = key = iterator.next();
            String suffix = "";
            short dataValue = -1;
            if (key.contains(".") || key.contains(":")) {
                String[] components = key.split("[.:]");
                material = components[0];
                if (components[1].equals("appendDefault")) continue;
                dataValue = Utils.tryParse(components[1], (short)-1);
                if (language.getLang().getBoolean(material + ".appendDefault", false)) {
                    suffix = language.getRaw(material, language.getRaw(material + ".default", ""));
                }
            }
            if ((mat = Material.matchMaterial((String)material)) == null) continue;
            this.names.computeIfAbsent(mat, k -> new HashMap());
            this.names.get(mat).put(dataValue, language.getRaw(key, "") + suffix);
            ++translationCount;
        }
        logger.log(Level.INFO, FINISHED_LOADING_MESSAGE, translationCount);
    }

    @NotNull
    public String getName(@NotNull Material material) {
        return this.getName(material, (short)-1);
    }

    @NotNull
    public String getName(@NotNull Material material, short dataValue) {
        Map<Short, String> namesForMaterial = this.names.get(material);
        if (namesForMaterial != null) {
            if (dataValue >= -1 && namesForMaterial.containsKey(dataValue)) {
                return namesForMaterial.get(dataValue);
            }
            if (namesForMaterial.containsKey((short)-1)) {
                return namesForMaterial.get((short)-1);
            }
        }
        return material.name().toLowerCase();
    }

    @NotNull
    public String getName(@NotNull MinecraftMaterial material) {
        return this.getName(material.getMaterial(), material.getDataValue());
    }

    @NotNull
    public String getName(@NotNull Block block) {
        return this.getName(block.getType(), block.getData());
    }

    @NotNull
    public String getName(@NotNull ItemStack itemStack) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return MessageColor.stripColorAndFormat(itemStack.getItemMeta().getDisplayName());
        }
        return this.getName(itemStack.getType(), itemStack.getDurability());
    }

    @NotNull
    public String getDisplayName(@NotNull ItemStack itemStack) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return MessageColor.GRAY + this.getName(itemStack.getType(), itemStack.getDurability());
    }
}

