/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MinecraftMaterial;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFilter {
    private final boolean whitelistMode;
    private final Set<MinecraftMaterial> filteredMaterials = new HashSet<MinecraftMaterial>();
    private final Set<String> filteredNames = new HashSet<String>();
    private final Set<String> filteredLore = new HashSet<String>();

    public ItemFilter(boolean whitelistMode) {
        this.whitelistMode = whitelistMode;
    }

    public void addFilteredNames(Collection<String> filteredNamesToBeAdded) {
        this.filteredNames.addAll(filteredNamesToBeAdded);
    }

    public void addFilteredLore(Collection<String> filteredLoreToBeAdded) {
        this.filteredLore.addAll(filteredLoreToBeAdded);
    }

    public void addFilteredMaterials(Collection<MinecraftMaterial> filteredMaterialsToBeAdded) {
        this.filteredMaterials.addAll(filteredMaterialsToBeAdded);
    }

    @Contract(value="null->false")
    public boolean isItemBlocked(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.filteredMaterials.contains(new MinecraftMaterial(item))) {
            return !this.whitelistMode;
        }
        if (item.hasItemMeta()) {
            return this.isItemMetaBlocked(item.getItemMeta());
        }
        return this.whitelistMode;
    }

    private boolean isItemMetaBlocked(@NotNull ItemMeta meta) {
        if (meta.hasDisplayName() && this.filteredNames.contains(meta.getDisplayName())) {
            return !this.whitelistMode;
        }
        if (meta.hasLore() && !this.filteredLore.isEmpty()) {
            StringBuilder loreBuilder = new StringBuilder();
            for (String loreLine : meta.getLore()) {
                if (this.filteredLore.contains(loreLine)) {
                    return !this.whitelistMode;
                }
                if (loreBuilder.length() > 0) {
                    loreBuilder.append("\n");
                }
                loreBuilder.append(loreLine);
            }
            if (this.filteredLore.contains(loreBuilder.toString())) {
                return !this.whitelistMode;
            }
        }
        return this.whitelistMode;
    }
}

