/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.GuiButton;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.IGui;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Util.InventoryUtils;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGui
implements IGui {
    private final Inventory inventory;
    private final GuiButton[] buttons;
    private final Object preparedTitle;

    public SimpleGui(String title, int rows) {
        this(new Message(title), rows, new Object[0]);
    }

    public SimpleGui(Message title, int rows, Object ... args) {
        if (rows < 0 || rows > 6) {
            throw new IllegalArgumentException("Row count must be > 0 and < 7");
        }
        this.buttons = new GuiButton[9 * rows];
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.buttons.length, (String)title.getClassicMessage());
        this.preparedTitle = InventoryUtils.prepareTitleForOpenInventoryWithCustomTitle(title, args);
    }

    public void setButton(int slot, @Nullable GuiButton button) {
        this.buttons[slot] = button;
        this.inventory.setItem(slot, button == null ? null : button.getItem());
    }

    public void setButton(int column, int row, @Nullable GuiButton button) {
        this.setButton(column + 9 * row, button);
    }

    public boolean addButton(@NotNull GuiButton button) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.buttons[i] != null) continue;
            this.setButton(i, button);
            return true;
        }
        return false;
    }

    public GuiButton getButton(int slot) {
        return this.buttons[slot];
    }

    public GuiButton getButton(int column, int row) {
        return this.getButton(column + 9 * row);
    }

    @Override
    public void show(@NotNull Player player) {
        InventoryUtils.openInventoryWithCustomTitlePrepared(player, this.inventory, this.preparedTitle);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event.getRawSlot() >= this.buttons.length || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        GuiButton button = this.buttons[event.getRawSlot()];
        if (button == null) {
            return;
        }
        button.onClick((Player)event.getWhoClicked(), event.getClick(), event.getCursor());
    }

    @Override
    public void onOpen(@NotNull Player player) {
    }

    @Override
    public void onClose(@NotNull Player player) {
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }
}

