/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.MCVersion;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiButton {
    public static final Sound MINECRAFT_CLICK_SOUND;
    public static final GuiButton EMPTY_BUTTON;
    @Nullable
    private final ItemStack item;
    @NotNull
    private final ButtonClickHandler clickEvent;
    @Nullable
    private final Sound clickSound;

    public GuiButton(@Nullable ItemStack itemStack, @NotNull ButtonClickHandler clickEvent) {
        this(itemStack, clickEvent, MINECRAFT_CLICK_SOUND);
    }

    public void onClick(@NotNull Player player, @NotNull ClickType clickType, @Nullable ItemStack cursor) {
        if (this.clickSound != null) {
            player.playSound(player.getEyeLocation(), this.clickSound, 1.0f, 1.0f);
        }
        this.clickEvent.onClick(player, clickType, cursor);
    }

    @Nullable
    @Generated
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    @Generated
    public ButtonClickHandler getClickEvent() {
        return this.clickEvent;
    }

    @Nullable
    @Generated
    public Sound getClickSound() {
        return this.clickSound;
    }

    @Generated
    public GuiButton(@Nullable ItemStack item, @NotNull ButtonClickHandler clickEvent, @Nullable Sound clickSound) {
        if (clickEvent == null) {
            throw new NullPointerException("clickEvent is marked non-null but is null");
        }
        this.item = item;
        this.clickEvent = clickEvent;
        this.clickSound = clickSound;
    }

    static {
        Sound sound = null;
        try {
            sound = Sound.valueOf((String)(MCVersion.isNewerOrEqualThan(MCVersion.MC_1_9_2) ? "UI_BUTTON_CLICK" : "CLICK"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        MINECRAFT_CLICK_SOUND = sound;
        EMPTY_BUTTON = new GuiButton(null, (player, clickType, cursor) -> {}, null);
    }

    public static interface ButtonClickHandler {
        public void onClick(@NotNull Player var1, @NotNull ClickType var2, @Nullable ItemStack var3);
    }
}

