/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.GuiButton;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.IGui;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.MultiPageGui;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.MultiPageGuiPage;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.Navigation.CompactNavigationStyleProducer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.Navigation.DefaultNavigationStyleProducer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.Navigation.INavigationStyleProducer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.Navigation.PagesOnlyNavigationStyleProducer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.NavigationStyle;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.GUI.SimpleGui;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiBuilder {
    @NotNull
    private final List<GuiButton> buttons = new ArrayList<GuiButton>();
    private int minRowsPerPage = 1;
    private int maxRowsPerPage = 6;
    @NotNull
    private Message title;
    @NotNull
    private Message multiPageTitleFormat;
    @NotNull
    private INavigationStyleProducer navigationStyleProducer = new DefaultNavigationStyleProducer();

    public GuiBuilder(@NotNull String title) {
        this(new Message(title));
    }

    public GuiBuilder(@NotNull String title, @Nullable String multiPageTitleFormat) {
        this(new Message(title), multiPageTitleFormat != null ? new Message(multiPageTitleFormat) : null);
    }

    public GuiBuilder(@NotNull Message title) {
        this(title, title);
    }

    public GuiBuilder(@NotNull Message title, @Nullable Message multiPageTitleFormat) {
        this.title = title;
        if (multiPageTitleFormat == null) {
            multiPageTitleFormat = title;
        }
        this.multiPageTitleFormat = (Message)multiPageTitleFormat.replaceAll("\\{PageNr}", "%d");
    }

    public void setMinRowsPerPage(int rows) {
        if (rows < 1 || rows > 6) {
            throw new IllegalArgumentException("The amount of rows must be between 1 and 6!");
        }
        Validate.isTrue((rows <= this.maxRowsPerPage ? 1 : 0) != 0, (String)"Min rows must be <= max rows (%d)!", (long)this.maxRowsPerPage);
        this.minRowsPerPage = rows;
    }

    public void setMaxRowsPerPage(int rows) {
        if (rows < 2 || rows > 6) {
            throw new IllegalArgumentException("The amount of rows must be between 2 and 6!");
        }
        this.maxRowsPerPage = rows;
        if (this.maxRowsPerPage < this.minRowsPerPage) {
            this.minRowsPerPage = rows;
        }
    }

    public void addButton(@Nullable GuiButton button) {
        if (button == null) {
            button = GuiButton.EMPTY_BUTTON;
        }
        this.buttons.add(button);
    }

    public void addButtons(@NotNull Collection<GuiButton> buttons) {
        buttons.forEach(this::addButton);
    }

    public void removeButton(@NotNull GuiButton button) {
        this.buttons.remove(button);
    }

    public void removeButton(int index) {
        this.buttons.remove(index);
    }

    public void removeButtons(@NotNull Collection<GuiButton> buttons) {
        this.buttons.removeAll(buttons);
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public void setNavigationStyle(NavigationStyle navigationStyle) {
        switch (navigationStyle) {
            case COMPACT: {
                this.navigationStyleProducer = new CompactNavigationStyleProducer();
                break;
            }
            case DEFAULT: {
                this.navigationStyleProducer = new DefaultNavigationStyleProducer();
                break;
            }
            case PAGES_ONLY: {
                this.navigationStyleProducer = new PagesOnlyNavigationStyleProducer();
            }
        }
    }

    public int size() {
        return this.buttons.size();
    }

    public int neededRows() {
        return (int)Math.ceil((double)this.size() / 9.0);
    }

    public int getPageCount() {
        return 1 + this.neededRows() / (this.maxRowsPerPage - 1);
    }

    public int getItemsPerPage() {
        return this.maxRowsPerPage * 9 - this.navigationStyleProducer.getSize();
    }

    @NotNull
    public IGui build() {
        return this.size() > this.maxRowsPerPage * 9 ? this.buildMultiPageGui() : this.buildSinglePageGui();
    }

    @NotNull
    private IGui buildSinglePageGui() {
        SimpleGui gui = new SimpleGui(this.title, Math.max(this.minRowsPerPage, this.neededRows()), new Object[0]);
        this.buttons.forEach(gui::addButton);
        return gui;
    }

    @NotNull
    private IGui buildMultiPageGui() {
        MultiPageGui gui = new MultiPageGui();
        int itemsPerPage = this.getItemsPerPage();
        MultiPageGuiPage[] pages = this.navigationStyleProducer.setupPages(gui, this);
        int count = 0;
        int page = 0;
        for (GuiButton button : this.buttons) {
            pages[page].addButton(button);
            if (++count / itemsPerPage <= page) continue;
            ++page;
        }
        gui.setPages(pages);
        return gui;
    }

    @Generated
    public int getMinRowsPerPage() {
        return this.minRowsPerPage;
    }

    @Generated
    public int getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    @NotNull
    @Generated
    public Message getTitle() {
        return this.title;
    }

    @NotNull
    @Generated
    public Message getMultiPageTitleFormat() {
        return this.multiPageTitleFormat;
    }

    @Generated
    public void setTitle(@NotNull Message title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @Generated
    public void setMultiPageTitleFormat(@NotNull Message multiPageTitleFormat) {
        if (multiPageTitleFormat == null) {
            throw new NullPointerException("multiPageTitleFormat is marked non-null but is null");
        }
        this.multiPageTitleFormat = multiPageTitleFormat;
    }

    @NotNull
    @Generated
    public INavigationStyleProducer getNavigationStyleProducer() {
        return this.navigationStyleProducer;
    }

    @Generated
    public void setNavigationStyleProducer(@NotNull INavigationStyleProducer navigationStyleProducer) {
        if (navigationStyleProducer == null) {
            throw new NullPointerException("navigationStyleProducer is marked non-null but is null");
        }
        this.navigationStyleProducer = navigationStyleProducer;
    }
}

