/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Debug;

import java.util.logging.Logger;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class EventToStringUtil {
    private EventToStringUtil() {
    }

    public static String toString(@NotNull LivingEntity player) {
        return String.format("%s (%s)", player.getName(), player.getUniqueId().toString());
    }

    public static String toString(@NotNull ItemStack itemStack) {
        return String.format("{ type: %s; amount: %d; durability: %d }", itemStack.getType().name(), itemStack.getAmount(), itemStack.getDurability());
    }

    public static String toString(@NotNull Item item) {
        return String.format("{ pickupDelay: %d; itemStack: %s}", item.getPickupDelay(), EventToStringUtil.toString(item.getItemStack()));
    }

    public static void logEvent(@NotNull Logger logger, @NotNull InventoryClickEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull InventoryClickEvent event) {
        return String.format("InventoryClickEvent { action: %s; click: %s; currentItem: %s; cursor: %s; slot: %d; rawSlot: %d; slotType: %s; whoClicked: %s; hotbarButton: %d }", event.getAction().name(), event.getClick().name(), event.getCurrentItem() != null ? event.getCurrentItem().getType().name() : "null", event.getCursor() != null ? event.getCursor().getType().name() : "null", event.getSlot(), event.getRawSlot(), event.getSlotType().name(), EventToStringUtil.toString((LivingEntity)event.getWhoClicked()), event.getHotbarButton());
    }

    public static void logEvent(@NotNull Logger logger, @NotNull InventoryDragEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull InventoryDragEvent event) {
        return String.format("InventoryDragEvent { cursor: %s; oldCursor: %s; slots: %s; raw-slots: %s whoClicked: %s }", event.getCursor() != null ? event.getCursor().getType().name() : "null", event.getOldCursor().getType().name(), event.getInventorySlots().toString(), event.getRawSlots().toString(), EventToStringUtil.toString((LivingEntity)event.getWhoClicked()));
    }

    public static void logEvent(@NotNull Logger logger, @NotNull EntityPickupItemEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull EntityPickupItemEvent event) {
        return String.format("EntityPickupItemEvent { item: %s; remaining: %d; entity: %s }", EventToStringUtil.toString(event.getItem()), event.getRemaining(), EventToStringUtil.toString(event.getEntity()));
    }

    public static void logEvent(@NotNull Logger logger, @NotNull PlayerInteractEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull PlayerInteractEvent event) {
        return String.format("PlayerInteractEvent { action: %s; player: %s; item: %s; hand: %s }", event.getAction().name(), EventToStringUtil.toString((LivingEntity)event.getPlayer()), EventToStringUtil.toString(event.getItem()), event.getHand());
    }

    public static void logEvent(@NotNull Logger logger, @NotNull PlayerSwapHandItemsEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull PlayerSwapHandItemsEvent event) {
        return String.format("PlayerSwapHandItemsEvent { player: %s; mainHand: %s; offHand: %s }", EventToStringUtil.toString((LivingEntity)event.getPlayer()), EventToStringUtil.toString(event.getMainHandItem()), EventToStringUtil.toString(event.getOffHandItem()));
    }

    public static void logEvent(@NotNull Logger logger, @NotNull AsyncPlayerPreLoginEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull AsyncPlayerPreLoginEvent event) {
        return String.format("AsyncPreLoginEvent { name: %s; uuid: %s; ip: %s; kickMessage: %s; result: %s }", event.getName(), event.getUniqueId().toString(), event.getAddress().toString(), event.getKickMessage(), event.getLoginResult().name());
    }

    public static void logEvent(@NotNull Logger logger, @NotNull PlayerLoginEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull PlayerLoginEvent event) {
        return String.format("PlayerLoginEvent { player: %s; ip: %s (%s); kickMessage: %s; result: %s }", EventToStringUtil.toString((LivingEntity)event.getPlayer()), event.getAddress().toString(), event.getHostname(), event.getKickMessage(), event.getResult().name());
    }

    public static void logEvent(@NotNull Logger logger, @NotNull PlayerLocaleChangeEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull PlayerLocaleChangeEvent event) {
        return String.format("PlayerLocaleChangeEvent { player: %s; locale: %s }", EventToStringUtil.toString((LivingEntity)event.getPlayer()), event.getLocale());
    }

    public static void logEvent(@NotNull Logger logger, @NotNull PlayerQuitEvent event) {
        logger.info(() -> EventToStringUtil.toString(event));
    }

    public static String toString(@NotNull PlayerQuitEvent event) {
        return String.format("PlayerQuitEvent { player: %s; quitMessage: %s }", EventToStringUtil.toString((LivingEntity)event.getPlayer()), event.getQuitMessage());
    }
}

