/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Database.Cache.UnCacheStrategies;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.BaseUnCacheStrategy;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.ICacheablePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.IPlayerCache;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class OnDisconnectDelayed
extends BaseUnCacheStrategy
implements Listener {
    private final Plugin plugin;
    private final long delay;

    public OnDisconnectDelayed(@NotNull Plugin plugin, @NotNull IPlayerCache cache, long delay) {
        super(cache);
        this.plugin = plugin;
        this.delay = delay;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLeaveEvent(PlayerQuitEvent event) {
        final ICacheablePlayer player = this.cache.getCachedPlayer(event.getPlayer().getUniqueId());
        if (player != null && player.canBeUncached()) {
            new BukkitRunnable(){

                public void run() {
                    if (!player.isOnline()) {
                        OnDisconnectDelayed.this.cache.unCache(player);
                    }
                }
            }.runTaskLater(this.plugin, this.delay);
        }
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }
}

