/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bukkit.Command;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterablePluginCommand
extends Command
implements PluginIdentifiableCommand {
    private static final Field FIELD_KNOWN_COMMANDS = Reflection.getField(SimpleCommandMap.class, "knownCommands");
    private final Plugin owningPlugin;
    private CommandExecutor executor;
    private String fallbackPrefix;
    private TabCompleter tabCompleter = null;
    private Map<String, Command> knownCommandsMapCache = null;

    public RegisterablePluginCommand(@NotNull Plugin owner, @NotNull String name, String ... aliases) {
        super(name);
        this.executor = owner;
        this.owningPlugin = owner;
        this.usageMessage = "/<command>";
        this.fallbackPrefix = owner.getName().toLowerCase(Locale.ENGLISH);
        ArrayList<String> aliasesList = new ArrayList<String>();
        if (aliases != null) {
            for (String alias : aliases) {
                if (alias == null || name.equalsIgnoreCase(alias)) continue;
                aliasesList.add(alias);
            }
            this.setAliases(aliasesList);
        }
    }

    public void registerCommand() {
        try {
            Field bukkitCommandMap = this.owningPlugin.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            ((CommandMap)bukkitCommandMap.get(this.owningPlugin.getServer())).register(this.fallbackPrefix, (Command)this);
        }
        catch (Exception e) {
            this.owningPlugin.getLogger().log(Level.WARNING, "Failed registering command!", e);
        }
    }

    public void unregisterCommand() {
        try {
            Field result = this.owningPlugin.getServer().getPluginManager().getClass().getDeclaredField("commandMap");
            result.setAccessible(true);
            this.knownCommandsMapCache = (Map)FIELD_KNOWN_COMMANDS.get(result.get(this.owningPlugin.getServer().getPluginManager()));
            this.removeCommand(this.getName(), 3);
            for (String alias : this.getAliases()) {
                this.removeCommand(alias, 3);
            }
        }
        catch (Exception e) {
            this.owningPlugin.getLogger().log(Level.WARNING, "Failed unregistering command!", e);
        }
    }

    private void removeCommand(String command, int depth) {
        if (depth < 0) {
            return;
        }
        if (this.knownCommandsMapCache.get(command) == this) {
            this.knownCommandsMapCache.remove(command);
        }
        this.removeCommand(this.fallbackPrefix + ':' + command, depth - 1);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        boolean success = false;
        if (this.owningPlugin.isEnabled()) {
            try {
                success = this.executor.onCommand(sender, (Command)this, commandLabel, args);
            }
            catch (Throwable e) {
                String cmd = commandLabel + ' ' + StringUtils.arrayToString(args);
                sender.sendMessage("Unhandled exception executing command '" + cmd + "': " + StringUtils.getErrorMessage(e));
                this.owningPlugin.getLogger().log(Level.WARNING, "Unhandled exception executing command '" + cmd + "' in plugin " + this.owningPlugin.getDescription().getFullName(), e);
            }
            if (!success && this.usageMessage.length() > 0) {
                for (String line : this.usageMessage.replace("<command>", commandLabel).split("\n")) {
                    sender.sendMessage(line);
                }
            }
        }
        return success;
    }

    public void setExecutor(@Nullable CommandExecutor executor) {
        this.executor = executor == null ? this.owningPlugin : executor;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public Plugin getPlugin() {
        return this.owningPlugin;
    }

    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        List completions = null;
        try {
            if (this.tabCompleter != null) {
                completions = this.tabCompleter.onTabComplete(sender, (Command)this, alias, args);
            }
            if (completions == null && this.executor instanceof TabCompleter) {
                completions = ((TabCompleter)this.executor).onTabComplete(sender, (Command)this, alias, args);
            }
        }
        catch (Throwable ex) {
            StringBuilder message = new StringBuilder("Unhandled exception during tab completion for command '/").append(alias);
            for (String arg : args) {
                message.append(' ').append(arg);
            }
            message.append("' in plugin ").append(this.owningPlugin.getDescription().getFullName());
            throw new CommandException(message.toString(), ex);
        }
        if (completions == null) {
            return super.tabComplete(sender, alias, args);
        }
        return completions;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(", ").append(this.owningPlugin.getDescription().getFullName()).append(')');
        return stringBuilder.toString();
    }

    @Generated
    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }

    @Generated
    public void setFallbackPrefix(String fallbackPrefix) {
        this.fallbackPrefix = fallbackPrefix;
    }

    @Generated
    public TabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    @Generated
    public void setTabCompleter(TabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter;
    }
}

