/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.Database.BaseDatabase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class PluginChannelCommunicatorBase {
    protected static final String CHANNEL_MARRIAGE_MASTER = "marriagemaster:main";
    protected static final String CHANNEL_BUNGEE_CORD = "BungeeCord";
    protected final Logger logger;
    protected final BaseDatabase database;

    protected PluginChannelCommunicatorBase(Logger logger, BaseDatabase database) {
        this.logger = logger;
        this.database = database;
        database.setCommunicatorBase(this);
    }

    public void close() {
    }

    protected static byte[] buildStringMessage(String ... msg) {
        byte[] data;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(stream);){
            for (String param : msg) {
                out.writeUTF(param);
            }
            out.flush();
            data = stream.toByteArray();
        }
        catch (IOException ignored) {
            data = new byte[]{};
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean receive(@NotNull String channel, @NotNull byte[] bytes) {
        if (!channel.equals(CHANNEL_MARRIAGE_MASTER)) {
            this.receiveUnknownChannel(channel, bytes);
            return false;
        }
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));){
            String cmd;
            switch (cmd = in.readUTF()) {
                case "updateHome": {
                    Object marriage = this.database.getCache().getMarriageFromDbKey(Integer.parseInt(in.readUTF()));
                    this.database.loadHome(marriage);
                    break;
                }
                case "updatePvP": {
                    Object marriage = this.database.getCache().getMarriageFromDbKey(Integer.parseInt(in.readUTF()));
                    if (marriage == null) break;
                    ((MarriageDataBase)marriage).updatePvPState(Boolean.parseBoolean(in.readUTF()));
                    break;
                }
                case "updateMarriageColor": {
                    Object marriage = this.database.getCache().getMarriageFromDbKey(Integer.parseInt(in.readUTF()));
                    if (marriage == null) break;
                    String color = in.readUTF();
                    ((MarriageDataBase)marriage).updateColor(color.equalsIgnoreCase("null") ? null : MessageColor.valueOf(color));
                    break;
                }
                case "updateSurname": {
                    Object marriage = this.database.getCache().getMarriageFromDbKey(Integer.parseInt(in.readUTF()));
                    if (marriage == null) break;
                    String surname = in.readUTF();
                    ((MarriageDataBase)marriage).updateSurname(surname.equals("null") ? null : surname);
                    break;
                }
                case "updateBackpackShare": {
                    Object playerData = this.database.getCache().getPlayerFromDbKey(Integer.parseInt(in.readUTF()));
                    if (playerData == null) break;
                    ((MarriagePlayerDataBase)playerData).setSharesBackpack(Boolean.parseBoolean(in.readUTF()));
                    break;
                }
                case "updatePriestStatus": {
                    Object playerData = this.database.getCache().getPlayerFromDbKey(Integer.parseInt(in.readUTF()));
                    if (playerData == null) break;
                    ((MarriagePlayerDataBase)playerData).setPriestData(Boolean.parseBoolean(in.readUTF()));
                    break;
                }
                case "updateMarry": {
                    this.database.loadMarriage(Integer.parseInt(in.readUTF()));
                    break;
                }
                case "updateDivorce": {
                    Object marriage = this.database.getCache().getMarriageFromDbKey(Integer.parseInt(in.readUTF()));
                    if (marriage == null) break;
                    ((MarriageDataBase)marriage).updateDivorce();
                    this.database.cachedDivorce(marriage, false);
                    break;
                }
                default: {
                    if (this.receiveMarriageMaster(cmd, in)) break;
                    this.logger.info((Object)((Object)ConsoleColor.YELLOW) + "Received unknown command via plugin channel! Command: " + cmd + "   " + (Object)((Object)ConsoleColor.RESET));
                    this.logger.info("There are two likely reasons for that. 1. You are running an outdated version of the plugin. 2. Someone has connected to your server directly, check you setup!");
                }
            }
            if (!cmd.startsWith("update")) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed reading message from the bungee!", e);
            return false;
        }
    }

    protected abstract void receiveUnknownChannel(@NotNull String var1, @NotNull byte[] var2);

    protected abstract boolean receiveMarriageMaster(@NotNull String var1, @NotNull DataInputStream var2) throws IOException;

    protected abstract void sendMessage(@NotNull byte[] var1);

    public void sendMessage(String ... msg) {
        this.sendMessage(PluginChannelCommunicatorBase.buildStringMessage(msg));
    }

    public void updateHome(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updateHome", marriage.getDatabaseKey().toString());
        }
    }

    public void updatePvP(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updatePvP", marriage.getDatabaseKey().toString(), "" + marriage.isPVPEnabled());
        }
    }

    public void updateMarriageColor(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updateMarriageColor", marriage.getDatabaseKey().toString(), "" + marriage.getColor());
        }
    }

    public void updateSurname(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updateSurname", marriage.getDatabaseKey().toString(), marriage.getSurname() != null ? marriage.getSurname() : "null");
        }
    }

    public void updateBackpackShareState(MarriagePlayerDataBase player) {
        if (player.getDatabaseKey() != null) {
            this.sendMessage("updateBackpackShare", player.getDatabaseKey().toString(), "" + player.isSharingBackpack());
        }
    }

    public void updatePriestStatus(MarriagePlayerDataBase player) {
        if (player.getDatabaseKey() != null) {
            this.sendMessage("updatePriestStatus", player.getDatabaseKey().toString(), "" + player.isPriest());
        }
    }

    public void marry(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updateMarry", marriage.getDatabaseKey().toString());
        }
    }

    public void divorce(MarriageDataBase marriage) {
        if (marriage.getDatabaseKey() != null) {
            this.sendMessage("updateDivorce", marriage.getDatabaseKey().toString());
        }
    }
}

