/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Database.Helper;

import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.SQLBasedDatabase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.DatabaseElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.DBTools;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DbElementStatementRunnable
implements Runnable {
    protected final DatabaseElement databaseElement;
    protected final SQLBasedDatabase database;
    @Language(value="SQL")
    protected final String query;
    protected final Object[] args;

    public DbElementStatementRunnable(@NotNull SQLBasedDatabase database, @NotNull DatabaseElement databaseElement, @NonNls @Language(value="SQL") String query, Object ... args) {
        this.databaseElement = databaseElement;
        this.database = database;
        this.query = query;
        this.args = args;
    }

    @Override
    public void run() {
        if (!(this.databaseElement.getDatabaseKey() instanceof Integer)) {
            return;
        }
        try (Connection connection = this.database.getConnection();){
            this.runStatement(connection);
        }
        catch (SQLException e) {
            Logger logger = this.database.getLogger();
            logger.log(Level.SEVERE, e, () -> String.format("Failed to execute sql command: %s, with: %s, error: %s", this.query, Arrays.toString(this.args), e.getMessage()));
        }
    }

    protected void runStatement(Connection connection) {
        DBTools.runStatementWithoutException(connection, this.query, this.args);
    }
}

