/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Database.FilesMigrator;

import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.DatabaseBackend;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.FilesMigrator.Files;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.FilesMigrator.MigrationMarriage;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.FilesMigrator.MigrationPlayer;
import java.io.File;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Converter {
    public static void runConverter(@NotNull Logger logger, @NotNull DatabaseConfiguration config, @NotNull DatabaseBackend newDB, File pluginDir) {
        logger.info("Loading config file ...");
        logger.info("Config file loaded.");
        Files f = new Files(config.getConfigE().getBoolean("Database.UseUUIDs", true), logger, pluginDir);
        Set<MigrationPlayer> players = f.getPlayers();
        Set<MigrationMarriage> marriages = f.getMarriages();
        f.close();
        logger.info("Start migration to " + newDB.getDatabaseTypeName() + " database ...");
        for (MigrationPlayer p : players) {
            newDB.migratePlayer(p);
        }
        logger.info("Finished writing players to " + newDB.getDatabaseTypeName() + " database.");
        logger.info("Writing marriages to " + newDB.getDatabaseTypeName() + " database ...");
        for (MigrationMarriage m : marriages) {
            newDB.migrateMarriage(m);
        }
        newDB.checkUUIDs();
        logger.info("Finished writing marriages to " + newDB.getDatabaseTypeName() + " database.");
        config.setDatabaseType(newDB.getDatabaseTypeName());
        logger.info("Finished migrating files to " + newDB.getDatabaseTypeName() + " database.");
    }

    private Converter() {
    }
}

