/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.ICacheablePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.Cache.IPlayerCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Cache<MARRIAGE_PLAYER_DATA extends MarriagePlayerDataBase, MARRIAGE_DATA extends MarriageDataBase>
implements IPlayerCache {
    private final Map<Object, MARRIAGE_PLAYER_DATA> databasePlayers = new ConcurrentHashMap<Object, MARRIAGE_PLAYER_DATA>();
    private final Map<Object, MARRIAGE_DATA> databaseMarriages = new ConcurrentHashMap<Object, MARRIAGE_DATA>();
    private final Map<UUID, MARRIAGE_PLAYER_DATA> players = new ConcurrentHashMap<UUID, MARRIAGE_PLAYER_DATA>();
    private final Map<String, MARRIAGE_DATA> surnames = new ConcurrentHashMap<String, MARRIAGE_DATA>();
    private final Set<MARRIAGE_DATA> marriages = ConcurrentHashMap.newKeySet();

    public void close() {
        this.clear();
    }

    public void clear() {
        this.databasePlayers.clear();
        this.databaseMarriages.clear();
        this.players.clear();
        this.surnames.clear();
        this.marriages.clear();
    }

    public void reCacheSurnames() {
        this.surnames.clear();
        for (MarriageDataBase marriage : this.marriages) {
            if (marriage.getSurname() == null || marriage.getSurname().isEmpty()) continue;
            this.surnames.put(marriage.getSurname(), marriage);
        }
    }

    public MARRIAGE_PLAYER_DATA getPlayer(UUID uuid) {
        return (MARRIAGE_PLAYER_DATA)((MarriagePlayerDataBase)this.players.get(uuid));
    }

    public Collection<MARRIAGE_PLAYER_DATA> getLoadedPlayers() {
        return this.players.values();
    }

    public Collection<MARRIAGE_DATA> getLoadedMarriages() {
        return this.marriages;
    }

    public Collection<String> getSurnames() {
        return this.surnames.keySet();
    }

    public void cache(MARRIAGE_PLAYER_DATA player) {
        this.players.put(((MarriagePlayerDataBase)player).getUUID(), player);
        if (((MarriagePlayerDataBase)player).getDatabaseKey() != null) {
            this.databasePlayers.put(((MarriagePlayerDataBase)player).getDatabaseKey(), player);
        }
    }

    public void cache(MARRIAGE_DATA marriage) {
        this.marriages.add(marriage);
        if (((MarriageDataBase)marriage).getDatabaseKey() != null) {
            this.databaseMarriages.put(((MarriageDataBase)marriage).getDatabaseKey(), marriage);
        }
        if (((MarriageDataBase)marriage).getSurname() != null && !((MarriageDataBase)marriage).getSurname().isEmpty()) {
            this.addSurname(marriage);
        }
    }

    public void unCache(MARRIAGE_PLAYER_DATA player) {
        this.players.remove(((MarriagePlayerDataBase)player).getUUID());
        if (((MarriagePlayerDataBase)player).getDatabaseKey() != null) {
            this.databasePlayers.remove(((MarriagePlayerDataBase)player).getDatabaseKey());
        }
    }

    public void unCache(MARRIAGE_DATA marriage) {
        this.marriages.remove(marriage);
        if (((MarriageDataBase)marriage).getDatabaseKey() != null) {
            this.databaseMarriages.remove(((MarriageDataBase)marriage).getDatabaseKey());
        }
        if (((MarriageDataBase)marriage).getSurname() != null && !((MarriageDataBase)marriage).getSurname().isEmpty()) {
            this.removeSurname(((MarriageDataBase)marriage).getSurname());
        }
    }

    public void addDbKey(MARRIAGE_PLAYER_DATA player) {
        if (((MarriagePlayerDataBase)player).getDatabaseKey() != null) {
            this.databasePlayers.put(((MarriagePlayerDataBase)player).getDatabaseKey(), player);
        }
    }

    public void addDbKey(MARRIAGE_DATA marriage) {
        if (((MarriageDataBase)marriage).getDatabaseKey() != null) {
            this.databaseMarriages.put(((MarriageDataBase)marriage).getDatabaseKey(), marriage);
        }
    }

    public MARRIAGE_DATA getMarriageFromDbKey(Object key) {
        return (MARRIAGE_DATA)((MarriageDataBase)this.databaseMarriages.get(key));
    }

    public boolean isPlayerFromDbKeyLoaded(Object key) {
        return this.databasePlayers.containsKey(key);
    }

    public MARRIAGE_PLAYER_DATA getPlayerFromDbKey(Object key) {
        return (MARRIAGE_PLAYER_DATA)((MarriagePlayerDataBase)this.databasePlayers.get(key));
    }

    public void removeSurname(String surname) {
        this.surnames.remove(surname);
    }

    public void addSurname(MARRIAGE_DATA marriage) {
        this.surnames.put(((MarriageDataBase)marriage).getSurname(), marriage);
    }

    @Override
    @Nullable
    public ICacheablePlayer getCachedPlayer(@NotNull UUID uuid) {
        return this.getPlayer(uuid);
    }

    @Override
    public void unCache(@NotNull ICacheablePlayer player) {
        this.unCache((MARRIAGE_DATA)((MarriagePlayerDataBase)player));
    }

    @Override
    @NotNull
    public Collection<? extends ICacheablePlayer> getCachedPlayers() {
        return this.getLoadedPlayers();
    }
}

