/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Database;

import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMaster.API.MarriageMasterPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.DatabaseBackend;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.MySQL;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.SQL;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.Backend.SQLite;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.Cache;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.FilesMigrator.Converter;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriageDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.PluginChannelCommunicatorBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import java.io.File;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDatabase<MARRIAGE_MASTER extends MarriageMasterPlugin, MARRIAGE_PLAYER_DATA extends MarriagePlayerDataBase, MARRIAGE_DATA extends MarriageDataBase, HOME extends Home> {
    private static BaseDatabase instance;
    protected static final String MESSAGE_FILES_NO_LONGER_SUPPORTED;
    protected static final String MESSAGE_UNKNOWN_DB_TYPE;
    protected static final String MESSAGE_CLEANING_DB_CACHE = "Cleaning database cache.";
    protected static final String MESSAGE_DB_CACHE_CLEANED = "Database cache cleaned.";
    protected final boolean bungee;
    protected final Logger logger;
    protected final MARRIAGE_MASTER plugin;
    protected final Cache<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA> cache = new Cache();
    protected final DatabaseBackend<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> backend;
    protected final IPlatformSpecific<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> platform;
    protected final Runnable loadRunnable;
    private PluginChannelCommunicatorBase communicatorBase = null;

    protected BaseDatabase(@NotNull MARRIAGE_MASTER plugin, @NotNull Logger logger, @NotNull IPlatformSpecific<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> platform, @NotNull DatabaseConfiguration dbConfig, @NotNull String pluginName, @NotNull File dataFolder, boolean bungee, boolean bungeeSupportRequired) {
        this.plugin = plugin;
        this.logger = logger;
        this.platform = platform;
        this.bungee = bungee;
        this.backend = this.getDatabaseBackend(platform, dbConfig, bungee, plugin.isSurnamesEnabled(), this.cache, logger, pluginName, dataFolder, bungeeSupportRequired);
        if (this.available()) {
            BaseDatabase.setInstance(this);
            this.loadRunnable = new LoadRunnable();
        } else {
            this.loadRunnable = null;
        }
    }

    public DatabaseBackend<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> getDatabaseBackend(@NotNull IPlatformSpecific<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> platform, @NotNull DatabaseConfiguration dbConfig, boolean bungee, boolean surnameEnabled, @NotNull Cache<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA> cache, @NotNull Logger logger, @NotNull String pluginName, @NotNull File dataFolder, boolean bungeeSupportRequired) {
        try {
            SQL db;
            String dbType = dbConfig.getDatabaseType();
            ConnectionProvider connectionProvider = platform.getExternalConnectionProvider(dbType, logger);
            switch (connectionProvider != null ? connectionProvider.getDatabaseType() : dbType) {
                case "mysql": 
                case "mariadb": {
                    db = new MySQL<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME>(platform, dbConfig, bungee, surnameEnabled, cache, logger, connectionProvider, pluginName);
                    break;
                }
                case "sqlite": {
                    db = new SQLite<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME>(platform, dbConfig, bungee, surnameEnabled, cache, logger, connectionProvider, pluginName, dataFolder);
                    break;
                }
                case "file": 
                case "files": 
                case "flat": {
                    logger.info(MESSAGE_FILES_NO_LONGER_SUPPORTED);
                    SQLite<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME> db2 = new SQLite<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA, HOME>(platform, dbConfig, bungee, surnameEnabled, cache, logger, null, pluginName, dataFolder);
                    ((DatabaseBackend)db2).startup();
                    Converter.runConverter(logger, dbConfig, db2, dataFolder);
                    return db2;
                }
                default: {
                    logger.warning(String.format(MESSAGE_UNKNOWN_DB_TYPE, dbType));
                    return null;
                }
            }
            if (!db.supportsBungeeCord()) {
                if (bungeeSupportRequired) {
                    logger.severe("Database type not supported on BungeeCord!");
                    ((DatabaseBackend)db).close();
                    return null;
                }
                if (bungee) {
                    logger.warning("The used database does not support multi-server setups! Please consider switching to MySQL!");
                }
            }
            ((DatabaseBackend)db).startup();
            return db;
        }
        catch (Exception ignored) {
            logger.severe("Failed to initialize database backend!");
            return null;
        }
    }

    public boolean available() {
        return this.backend != null;
    }

    public final boolean useBungee() {
        return this.bungee;
    }

    protected void close() {
        BaseDatabase.setInstance(null);
        this.logger.info(MESSAGE_CLEANING_DB_CACHE);
        this.cache.close();
        this.logger.info(MESSAGE_DB_CACHE_CLEANED);
        if (this.backend != null) {
            this.backend.close();
        }
    }

    void setCommunicatorBase(PluginChannelCommunicatorBase communicatorBase) {
        this.communicatorBase = communicatorBase;
        this.backend.setMarriageSavedCallback(communicatorBase::marry);
    }

    public Cache<MARRIAGE_PLAYER_DATA, MARRIAGE_DATA> getCache() {
        return this.cache;
    }

    public Collection<String> getSurnames() {
        return this.cache.getSurnames();
    }

    public void cachedSurnameUpdate(MARRIAGE_DATA marriage, String oldSurname) {
        this.cachedSurnameUpdate(marriage, oldSurname, true);
    }

    public void cachedSurnameUpdate(MARRIAGE_DATA marriage, String oldSurname, boolean updateDatabase) {
        if (updateDatabase) {
            this.updateSurname(marriage);
        }
        if (oldSurname != null && !oldSurname.isEmpty()) {
            this.cache.removeSurname(oldSurname);
        }
        if (((MarriageDataBase)marriage).getSurname() != null && !((MarriageDataBase)marriage).getSurname().isEmpty()) {
            this.cache.addSurname(marriage);
        }
    }

    public void cachedDivorce(@NotNull MARRIAGE_DATA marriage) {
        this.cachedDivorce(marriage, true);
    }

    public void cachedDivorce(@NotNull MARRIAGE_DATA marriage, boolean updateDatabase) {
        if (updateDatabase) {
            this.divorce(marriage);
        }
        this.cache.unCache(marriage);
    }

    public void cachedMarry(@NotNull MARRIAGE_DATA marriage) {
        this.marry(marriage);
        this.cache.cache(marriage);
    }

    public abstract MARRIAGE_PLAYER_DATA getPlayer(UUID var1);

    protected abstract void loadOnlinePlayers();

    protected void load(@NotNull MARRIAGE_PLAYER_DATA player) {
        this.backend.load(player);
    }

    public void loadMarriage(int marriageId) {
        if (this.backend instanceof SQL) {
            ((SQL)this.backend).loadMarriage(marriageId);
        }
    }

    public void loadHome(MARRIAGE_DATA marriage) {
        if (this.backend instanceof SQL) {
            ((SQL)this.backend).loadHome(marriage);
        }
    }

    public void updateHome(MARRIAGE_DATA marriage) {
        this.backend.updateHome(marriage);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updateHome((MarriageDataBase)marriage);
        }
    }

    public void updatePvPState(MARRIAGE_DATA marriage) {
        this.backend.updatePvPState(marriage);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updatePvP((MarriageDataBase)marriage);
        }
    }

    public void updateMarriageColor(MARRIAGE_DATA marriage) {
        this.backend.updateMarriageColor(marriage);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updateMarriageColor((MarriageDataBase)marriage);
        }
    }

    public void updateBackpackShareState(MARRIAGE_PLAYER_DATA player) {
        this.backend.updateBackpackShareState(player);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updateBackpackShareState((MarriagePlayerDataBase)player);
        }
    }

    public void updatePriestStatus(MARRIAGE_PLAYER_DATA player) {
        this.backend.updatePriestStatus(player);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updatePriestStatus((MarriagePlayerDataBase)player);
        }
    }

    protected void updateSurname(MARRIAGE_DATA marriage) {
        this.backend.updateSurname(marriage);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.updateSurname((MarriageDataBase)marriage);
        }
    }

    protected void marry(MARRIAGE_DATA marriage) {
        this.backend.marry(marriage);
    }

    protected void divorce(MARRIAGE_DATA marriage) {
        this.backend.divorce(marriage);
        if (this.bungee && this.communicatorBase != null) {
            this.communicatorBase.divorce((MarriageDataBase)marriage);
        }
    }

    public void resync() {
        this.logger.info("Performing resync with database");
        this.cache.clear();
        this.platform.runAsync(this.loadRunnable, 0L);
    }

    public static BaseDatabase getInstance() {
        return instance;
    }

    private static void setInstance(BaseDatabase instance) {
        BaseDatabase.instance = instance;
    }

    static {
        MESSAGE_FILES_NO_LONGER_SUPPORTED = (Object)((Object)ConsoleColor.RED) + "File based storage is no longer supported." + (Object)((Object)ConsoleColor.YELLOW) + " Migrating to SQLite." + (Object)((Object)ConsoleColor.RESET);
        MESSAGE_UNKNOWN_DB_TYPE = (Object)((Object)ConsoleColor.RED) + "Unknown database type \"%s\"!" + (Object)((Object)ConsoleColor.RESET);
    }

    private class LoadRunnable
    implements Runnable {
        private LoadRunnable() {
        }

        @Override
        public void run() {
            BaseDatabase.this.backend.loadAll();
            BaseDatabase.this.cache.reCacheSurnames();
            BaseDatabase.this.loadOnlinePlayers();
        }
    }
}

