/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bungee;

import at.pcgamingfreaks.MarriageMaster.Bungee.API.DelayableTeleportAction;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriageMasterPlugin;
import at.pcgamingfreaks.MarriageMaster.Bungee.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Commands.CommandManagerImplementation;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database.Config;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database.Database;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database.Language;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Listener.JoinLeaveInfo;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Listener.PluginChannelCommunicator;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.SpecialInfoWorker.NoDatabaseWorker;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.MarriagePlayerDataBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.ManagedUpdater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MarriageMaster
extends Plugin
implements MarriageMasterPlugin,
IPlugin {
    private static MarriageMaster instance = null;
    private ManagedUpdater updater;
    private Config config = null;
    private Language language = null;
    private Database database = null;
    private PluginChannelCommunicator pluginChannelCommunicator = null;
    private final CommandManagerImplementation commandManager = new CommandManagerImplementation(this);
    private boolean multiMarriage = false;
    private boolean selfMarriageAllowed = false;
    private boolean surnamesEnabled = false;
    private boolean surnamesForced = false;
    public Message messageNoPermission;
    public Message messageNotMarried;
    public Message messagePartnerOffline;
    public Message messageNotFromConsole;
    public Message messageTargetPartnerNotFound;
    public Message messagePlayerNotMarried;
    public Message messagePlayersNotMarried;
    public String helpPartnerNameVariable;

    public void onEnable() {
        this.updater = new ManagedUpdater(this);
        MarriageMaster.setInstance(this);
        this.config = new Config(this);
        this.language = new Language(this);
        if (!this.config.isLoaded()) {
            this.getLogger().info((Object)((Object)ConsoleColor.RED) + "Failed to enable the plugin! " + (Object)((Object)ConsoleColor.YELLOW) + " :( " + (Object)((Object)ConsoleColor.RESET));
            return;
        }
        this.updater.setChannel(this.config.getUpdateChannel());
        if (this.config.useUpdater()) {
            this.updater.update();
        }
        if (this.load()) {
            this.getLogger().info((Object)((Object)ConsoleColor.GREEN) + "Marriage Master has been enabled! " + (Object)((Object)ConsoleColor.YELLOW) + " :) " + (Object)((Object)ConsoleColor.RESET));
        } else {
            this.getLogger().info((Object)((Object)ConsoleColor.RED) + "Failed to enable the plugin! " + (Object)((Object)ConsoleColor.YELLOW) + " :( " + (Object)((Object)ConsoleColor.RESET));
        }
    }

    public void onDisable() {
        if (this.config != null && this.config.isLoaded() && this.database != null) {
            if (this.config.useUpdater()) {
                this.updater.update();
            }
            this.unload();
        }
        this.updater.waitForAsyncOperation();
        this.getLogger().info((Object)((Object)ConsoleColor.RED) + "Marriage Master has been disabled. " + (Object)((Object)ConsoleColor.YELLOW) + " :( " + (Object)((Object)ConsoleColor.RESET));
    }

    private boolean load() {
        if (!this.config.isLoaded() || !this.language.load(this.config)) {
            this.getLogger().warning((Object)((Object)ConsoleColor.RED) + "A critical error occurred! The plugin failed to load!" + (Object)((Object)ConsoleColor.RESET));
            return false;
        }
        this.updater.setChannel(this.config.getUpdateChannel());
        this.database = new Database(this);
        if (!this.database.available()) {
            this.getLogger().warning((Object)((Object)ConsoleColor.RED) + "Failed to connect to database! Please adjust your settings and retry!" + (Object)((Object)ConsoleColor.RESET));
            new NoDatabaseWorker(this);
            return false;
        }
        this.surnamesEnabled = this.config.isSurnamesEnabled();
        this.multiMarriage = this.config.areMultiplePartnersAllowed();
        this.selfMarriageAllowed = this.config.isSelfMarriageAllowed();
        this.surnamesForced = this.config.isSurnamesForced() && this.surnamesEnabled;
        this.helpPartnerNameVariable = this.language.get("Commands.PartnerNameVariable");
        this.messageNotFromConsole = this.language.getMessage("NotFromConsole");
        this.messageNotMarried = this.language.getMessage("Ingame.NotMarried");
        this.messageNoPermission = this.language.getMessage("Ingame.NoPermission");
        this.messagePartnerOffline = this.language.getMessage("Ingame.PartnerOffline");
        this.messageTargetPartnerNotFound = this.language.getMessage("Ingame.TargetPartnerNotFound");
        this.messagePlayerNotMarried = (Message)this.language.getMessage("Ingame.PlayerNotMarried").placeholder("PlayerName");
        this.messagePlayersNotMarried = this.language.getMessage("Ingame.PlayersNotMarried");
        this.pluginChannelCommunicator = new PluginChannelCommunicator(this);
        if (this.config.isJoinLeaveInfoEnabled()) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new JoinLeaveInfo(this));
        }
        this.commandManager.init();
        return true;
    }

    private void unload() {
        this.commandManager.close();
        this.getProxy().getPluginManager().unregisterCommands((Plugin)this);
        this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
        this.database.close();
        this.pluginChannelCommunicator.close();
        this.pluginChannelCommunicator = null;
    }

    public void reload() {
        this.unload();
        this.config.reload();
        this.load();
    }

    public Config getConfig() {
        return this.config;
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull ProxiedPlayer proxiedPlayer) {
        return this.database.getPlayer(proxiedPlayer.getUniqueId());
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull UUID uuid) {
        return this.database.getPlayer(uuid);
    }

    @Override
    @NotNull
    public MarriagePlayer getPlayerData(@NotNull String name) {
        ProxiedPlayer player = this.getProxy().getPlayer(name);
        if (player == null) {
            throw new RuntimeException("BungeeCord does not provide player objects for offline players!");
        }
        return this.getPlayerData(player);
    }

    @Override
    @NotNull
    public Collection<? extends Marriage> getMarriages() {
        return this.database.getCache().getLoadedMarriages();
    }

    @Override
    public boolean areMultiplePartnersAllowed() {
        return this.multiMarriage;
    }

    @Override
    public boolean isSelfDivorceAllowed() {
        return false;
    }

    @Override
    public void doDelayableTeleportAction(@NotNull DelayableTeleportAction action) {
    }

    @Override
    @NotNull
    public CommandManagerImplementation getCommandManager() {
        return this.commandManager;
    }

    @Override
    @NotNull
    public Collection<? extends MarriagePlayer> getPriestsOnline() {
        ArrayList<MarriagePlayer> priests = new ArrayList<MarriagePlayer>();
        for (ProxiedPlayer player : this.getProxy().getPlayers()) {
            MarriagePlayer marriagePlayer = this.getPlayerData(player);
            if (!marriagePlayer.isPriest()) continue;
            priests.add(marriagePlayer);
        }
        return priests;
    }

    @Override
    @NotNull
    public Collection<? extends MarriagePlayer> getPriests() {
        return this.database.getCache().getLoadedPlayers().stream().filter(MarriagePlayerDataBase::isPriest).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Version getVersion() {
        return new Version(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getName() {
        return this.getDescription().getName();
    }

    public static MarriageMaster getInstance() {
        return instance;
    }

    private static void setInstance(MarriageMaster instance) {
        MarriageMaster.instance = instance;
    }

    public ManagedUpdater getUpdater() {
        return this.updater;
    }

    public Language getLanguage() {
        return this.language;
    }

    public PluginChannelCommunicator getPluginChannelCommunicator() {
        return this.pluginChannelCommunicator;
    }

    @Override
    public boolean isSelfMarriageAllowed() {
        return this.selfMarriageAllowed;
    }

    @Override
    public boolean isSurnamesEnabled() {
        return this.surnamesEnabled;
    }

    @Override
    public boolean isSurnamesForced() {
        return this.surnamesForced;
    }
}

