/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database;

import at.pcgamingfreaks.MarriageMaster.API.Home;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database.MarriageData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.MarriageMaster;
import at.pcgamingfreaks.MarriageMasterStandalone.Bungee.SpecialInfoWorker.DbErrorLoadingDataInfo;
import at.pcgamingfreaks.MarriageMasterStandalone.Database.IPlatformSpecific;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformSpecific
implements IPlatformSpecific<MarriagePlayerData, MarriageData, Home> {
    private final MarriageMaster plugin;

    public PlatformSpecific(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public MarriagePlayerData producePlayer(@Nullable UUID uuid, @NotNull String name, boolean priest, boolean sharesBackpack, @Nullable Object databaseKey) {
        return new MarriagePlayerData(uuid, name, priest, sharesBackpack, databaseKey);
    }

    @Override
    @NotNull
    public MarriageData produceMarriage(@NotNull MarriagePlayerData player1, @NotNull MarriagePlayerData player2, @Nullable MarriagePlayerData priest, @NotNull Date weddingDate, @Nullable String surname, boolean pvpEnabled, @Nullable MessageColor color, @Nullable Home home, @Nullable Object databaseKey) {
        return new MarriageData(player1, player2, priest, weddingDate, surname, pvpEnabled, color, home, databaseKey);
    }

    @Override
    @NotNull
    public Home produceHome(@NotNull String name, @NotNull String world, @Nullable String server, double x, double y, double z, float yaw, float pitch) {
        return new Home(world, server, x, y, z, yaw, pitch);
    }

    @Override
    public void runAsync(@NotNull Runnable runnable, long delay) {
        if (delay > 0L) {
            this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, runnable, delay * 20L, TimeUnit.MILLISECONDS);
        } else {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, runnable);
        }
    }

    @Override
    @Nullable
    public ConnectionProvider getExternalConnectionProvider(@NotNull String dbType, @NotNull Logger logger) throws SQLException {
        ConnectionProvider connectionProvider = null;
        if (dbType.equals("shared") || dbType.equals("external") || dbType.equals("global")) {
            logger.warning((Object)((Object)ConsoleColor.RED) + "The shared database connection option is not available in standalone mode!" + (Object)((Object)ConsoleColor.RESET));
            throw new SQLException("The shared database connection option is not available in standalone mode!");
        }
        return connectionProvider;
    }

    @Override
    @NotNull
    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public void spawnDatabaseLoadingErrorMessage(String failedToLoad) {
        new DbErrorLoadingDataInfo(this.plugin, failedToLoad);
    }
}

